// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type TestAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// A list of authorization info objects. Simulating authorization will create
	// a response for each authInfo object in the list.
	//
	// AuthInfos is a required field
	AuthInfos []AuthInfo `locationName:"authInfos" min:"1" type:"list" required:"true"`

	// The MQTT client ID.
	ClientId *string `location:"querystring" locationName:"clientId" type:"string"`

	// The Cognito identity pool ID.
	CognitoIdentityPoolId *string `locationName:"cognitoIdentityPoolId" type:"string"`

	// When testing custom authorization, the policies specified here are treated
	// as if they are attached to the principal being authorized.
	PolicyNamesToAdd []string `locationName:"policyNamesToAdd" type:"list"`

	// When testing custom authorization, the policies specified here are treated
	// as if they are not attached to the principal being authorized.
	PolicyNamesToSkip []string `locationName:"policyNamesToSkip" type:"list"`

	// The principal.
	Principal *string `locationName:"principal" type:"string"`
}

// String returns the string representation
func (s TestAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestAuthorizationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TestAuthorizationInput"}

	if s.AuthInfos == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuthInfos"))
	}
	if s.AuthInfos != nil && len(s.AuthInfos) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthInfos", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TestAuthorizationInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.AuthInfos) > 0 {
		v := s.AuthInfos

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "authInfos", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CognitoIdentityPoolId != nil {
		v := *s.CognitoIdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cognitoIdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PolicyNamesToAdd) > 0 {
		v := s.PolicyNamesToAdd

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "policyNamesToAdd", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.PolicyNamesToSkip) > 0 {
		v := s.PolicyNamesToSkip

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "policyNamesToSkip", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Principal != nil {
		v := *s.Principal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principal", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientId != nil {
		v := *s.ClientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "clientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type TestAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// The authentication results.
	AuthResults []AuthResult `locationName:"authResults" type:"list"`
}

// String returns the string representation
func (s TestAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TestAuthorizationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AuthResults) > 0 {
		v := s.AuthResults

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "authResults", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opTestAuthorization = "TestAuthorization"

// TestAuthorizationRequest returns a request value for making API operation for
// AWS IoT.
//
// Tests if a specified principal is authorized to perform an AWS IoT action
// on a specified resource. Use this to test and debug the authorization behavior
// of devices that connect to the AWS IoT device gateway.
//
//    // Example sending a request using TestAuthorizationRequest.
//    req := client.TestAuthorizationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) TestAuthorizationRequest(input *TestAuthorizationInput) TestAuthorizationRequest {
	op := &aws.Operation{
		Name:       opTestAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/test-authorization",
	}

	if input == nil {
		input = &TestAuthorizationInput{}
	}

	req := c.newRequest(op, input, &TestAuthorizationOutput{})
	return TestAuthorizationRequest{Request: req, Input: input, Copy: c.TestAuthorizationRequest}
}

// TestAuthorizationRequest is the request type for the
// TestAuthorization API operation.
type TestAuthorizationRequest struct {
	*aws.Request
	Input *TestAuthorizationInput
	Copy  func(*TestAuthorizationInput) TestAuthorizationRequest
}

// Send marshals and sends the TestAuthorization API request.
func (r TestAuthorizationRequest) Send(ctx context.Context) (*TestAuthorizationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TestAuthorizationResponse{
		TestAuthorizationOutput: r.Request.Data.(*TestAuthorizationOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TestAuthorizationResponse is the response type for the
// TestAuthorization API operation.
type TestAuthorizationResponse struct {
	*TestAuthorizationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TestAuthorization request.
func (r *TestAuthorizationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
