// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input to the GetRegistrationCode operation.
type GetRegistrationCodeInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetRegistrationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRegistrationCodeInput) MarshalFields(e protocol.FieldEncoder) error {

	return nil
}

// The output from the GetRegistrationCode operation.
type GetRegistrationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The CA certificate registration code.
	RegistrationCode *string `locationName:"registrationCode" min:"64" type:"string"`
}

// String returns the string representation
func (s GetRegistrationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRegistrationCodeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RegistrationCode != nil {
		v := *s.RegistrationCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "registrationCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetRegistrationCode = "GetRegistrationCode"

// GetRegistrationCodeRequest returns a request value for making API operation for
// AWS IoT.
//
// Gets a registration code used to register a CA certificate with AWS IoT.
//
//    // Example sending a request using GetRegistrationCodeRequest.
//    req := client.GetRegistrationCodeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetRegistrationCodeRequest(input *GetRegistrationCodeInput) GetRegistrationCodeRequest {
	op := &aws.Operation{
		Name:       opGetRegistrationCode,
		HTTPMethod: "GET",
		HTTPPath:   "/registrationcode",
	}

	if input == nil {
		input = &GetRegistrationCodeInput{}
	}

	req := c.newRequest(op, input, &GetRegistrationCodeOutput{})
	return GetRegistrationCodeRequest{Request: req, Input: input, Copy: c.GetRegistrationCodeRequest}
}

// GetRegistrationCodeRequest is the request type for the
// GetRegistrationCode API operation.
type GetRegistrationCodeRequest struct {
	*aws.Request
	Input *GetRegistrationCodeInput
	Copy  func(*GetRegistrationCodeInput) GetRegistrationCodeRequest
}

// Send marshals and sends the GetRegistrationCode API request.
func (r GetRegistrationCodeRequest) Send(ctx context.Context) (*GetRegistrationCodeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRegistrationCodeResponse{
		GetRegistrationCodeOutput: r.Request.Data.(*GetRegistrationCodeOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRegistrationCodeResponse is the response type for the
// GetRegistrationCode API operation.
type GetRegistrationCodeResponse struct {
	*GetRegistrationCodeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRegistrationCode request.
func (r *GetRegistrationCodeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
