// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input for the DetachThingPrincipal operation.
type DetachThingPrincipalInput struct {
	_ struct{} `type:"structure"`

	// If the principal is a certificate, this value must be ARN of the certificate.
	// If the principal is an Amazon Cognito identity, this value must be the ID
	// of the Amazon Cognito identity.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachThingPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachThingPrincipalInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachThingPrincipalInput"}

	if s.Principal == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principal"))
	}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachThingPrincipalInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Principal != nil {
		v := *s.Principal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amzn-principal", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The output from the DetachThingPrincipal operation.
type DetachThingPrincipalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachThingPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachThingPrincipalOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDetachThingPrincipal = "DetachThingPrincipal"

// DetachThingPrincipalRequest returns a request value for making API operation for
// AWS IoT.
//
// Detaches the specified principal from the specified thing. A principal can
// be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities
// or federated identities.
//
// This call is asynchronous. It might take several seconds for the detachment
// to propagate.
//
//    // Example sending a request using DetachThingPrincipalRequest.
//    req := client.DetachThingPrincipalRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DetachThingPrincipalRequest(input *DetachThingPrincipalInput) DetachThingPrincipalRequest {
	op := &aws.Operation{
		Name:       opDetachThingPrincipal,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}/principals",
	}

	if input == nil {
		input = &DetachThingPrincipalInput{}
	}

	req := c.newRequest(op, input, &DetachThingPrincipalOutput{})
	return DetachThingPrincipalRequest{Request: req, Input: input, Copy: c.DetachThingPrincipalRequest}
}

// DetachThingPrincipalRequest is the request type for the
// DetachThingPrincipal API operation.
type DetachThingPrincipalRequest struct {
	*aws.Request
	Input *DetachThingPrincipalInput
	Copy  func(*DetachThingPrincipalInput) DetachThingPrincipalRequest
}

// Send marshals and sends the DetachThingPrincipal API request.
func (r DetachThingPrincipalRequest) Send(ctx context.Context) (*DetachThingPrincipalResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachThingPrincipalResponse{
		DetachThingPrincipalOutput: r.Request.Data.(*DetachThingPrincipalOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachThingPrincipalResponse is the response type for the
// DetachThingPrincipal API operation.
type DetachThingPrincipalResponse struct {
	*DetachThingPrincipalOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachThingPrincipal request.
func (r *DetachThingPrincipalResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
