// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRunRequest
type DeleteAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment run that you want to delete.
	//
	// AssessmentRunArn is a required field
	AssessmentRunArn *string `locationName:"assessmentRunArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssessmentRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAssessmentRunInput"}

	if s.AssessmentRunArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssessmentRunArn"))
	}
	if s.AssessmentRunArn != nil && len(*s.AssessmentRunArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentRunArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRunOutput
type DeleteAssessmentRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAssessmentRun = "DeleteAssessmentRun"

// DeleteAssessmentRunRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Deletes the assessment run that is specified by the ARN of the assessment
// run.
//
//    // Example sending a request using DeleteAssessmentRunRequest.
//    req := client.DeleteAssessmentRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRun
func (c *Client) DeleteAssessmentRunRequest(input *DeleteAssessmentRunInput) DeleteAssessmentRunRequest {
	op := &aws.Operation{
		Name:       opDeleteAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssessmentRunInput{}
	}

	req := c.newRequest(op, input, &DeleteAssessmentRunOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteAssessmentRunRequest{Request: req, Input: input, Copy: c.DeleteAssessmentRunRequest}
}

// DeleteAssessmentRunRequest is the request type for the
// DeleteAssessmentRun API operation.
type DeleteAssessmentRunRequest struct {
	*aws.Request
	Input *DeleteAssessmentRunInput
	Copy  func(*DeleteAssessmentRunInput) DeleteAssessmentRunRequest
}

// Send marshals and sends the DeleteAssessmentRun API request.
func (r DeleteAssessmentRunRequest) Send(ctx context.Context) (*DeleteAssessmentRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAssessmentRunResponse{
		DeleteAssessmentRunOutput: r.Request.Data.(*DeleteAssessmentRunOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAssessmentRunResponse is the response type for the
// DeleteAssessmentRun API operation.
type DeleteAssessmentRunResponse struct {
	*DeleteAssessmentRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAssessmentRun request.
func (r *DeleteAssessmentRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
