// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicyRequest
type GetGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the group the policy is associated with.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name of the policy document to get.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetGroupPolicyInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful GetGroupPolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicyResponse
type GetGroupPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The group the policy is associated with.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The policy document.
	//
	// IAM stores policies in JSON format. However, resources that were created
	// using AWS CloudFormation templates can be formatted in YAML. AWS CloudFormation
	// always converts a YAML policy to JSON format before submitting it to IAM.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetGroupPolicy = "GetGroupPolicy"

// GetGroupPolicyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves the specified inline policy document that is embedded in the specified
// IAM group.
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// An IAM group can also have managed policies attached to it. To retrieve a
// managed policy document that is attached to a group, use GetPolicy to determine
// the policy's default version, then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, see Managed Policies and Inline Policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
//    // Example sending a request using GetGroupPolicyRequest.
//    req := client.GetGroupPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy
func (c *Client) GetGroupPolicyRequest(input *GetGroupPolicyInput) GetGroupPolicyRequest {
	op := &aws.Operation{
		Name:       opGetGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGroupPolicyInput{}
	}

	req := c.newRequest(op, input, &GetGroupPolicyOutput{})
	return GetGroupPolicyRequest{Request: req, Input: input, Copy: c.GetGroupPolicyRequest}
}

// GetGroupPolicyRequest is the request type for the
// GetGroupPolicy API operation.
type GetGroupPolicyRequest struct {
	*aws.Request
	Input *GetGroupPolicyInput
	Copy  func(*GetGroupPolicyInput) GetGroupPolicyRequest
}

// Send marshals and sends the GetGroupPolicy API request.
func (r GetGroupPolicyRequest) Send(ctx context.Context) (*GetGroupPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGroupPolicyResponse{
		GetGroupPolicyOutput: r.Request.Data.(*GetGroupPolicyOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGroupPolicyResponse is the response type for the
// GetGroupPolicy API operation.
type GetGroupPolicyResponse struct {
	*GetGroupPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGroupPolicy request.
func (r *GetGroupPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
