// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Update Detector Request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetectorRequest
type UpdateDetectorInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// Updated boolean value for the detector that specifies whether the detector
	// is enabled.
	Enable *bool `locationName:"enable" type:"boolean"`

	// A enum value that specifies how frequently customer got Finding updates published.
	FindingPublishingFrequency FindingPublishingFrequency `locationName:"findingPublishingFrequency" type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDetectorInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDetectorInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Enable != nil {
		v := *s.Enable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enable", protocol.BoolValue(v), metadata)
	}
	if len(s.FindingPublishingFrequency) > 0 {
		v := s.FindingPublishingFrequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "findingPublishingFrequency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetectorResponse
type UpdateDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDetectorOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateDetector = "UpdateDetector"

// UpdateDetectorRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Updates an Amazon GuardDuty detector specified by the detectorId.
//
//    // Example sending a request using UpdateDetectorRequest.
//    req := client.UpdateDetectorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector
func (c *Client) UpdateDetectorRequest(input *UpdateDetectorInput) UpdateDetectorRequest {
	op := &aws.Operation{
		Name:       opUpdateDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}",
	}

	if input == nil {
		input = &UpdateDetectorInput{}
	}

	req := c.newRequest(op, input, &UpdateDetectorOutput{})
	return UpdateDetectorRequest{Request: req, Input: input, Copy: c.UpdateDetectorRequest}
}

// UpdateDetectorRequest is the request type for the
// UpdateDetector API operation.
type UpdateDetectorRequest struct {
	*aws.Request
	Input *UpdateDetectorInput
	Copy  func(*UpdateDetectorInput) UpdateDetectorRequest
}

// Send marshals and sends the UpdateDetector API request.
func (r UpdateDetectorRequest) Send(ctx context.Context) (*UpdateDetectorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDetectorResponse{
		UpdateDetectorOutput: r.Request.Data.(*UpdateDetectorOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDetectorResponse is the response type for the
// UpdateDetector API operation.
type UpdateDetectorResponse struct {
	*UpdateDetectorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDetector request.
func (r *UpdateDetectorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
