// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccountRequest
type GetMasterAccountInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMasterAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMasterAccountInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMasterAccountInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// GetMasterAccount response object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccountResponse
type GetMasterAccountOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the master account.
	Master *Master `locationName:"master" type:"structure"`
}

// String returns the string representation
func (s GetMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMasterAccountOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Master != nil {
		v := s.Master

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "master", v, metadata)
	}
	return nil
}

const opGetMasterAccount = "GetMasterAccount"

// GetMasterAccountRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Provides the details for the GuardDuty master account to the current GuardDuty
// member account.
//
//    // Example sending a request using GetMasterAccountRequest.
//    req := client.GetMasterAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount
func (c *Client) GetMasterAccountRequest(input *GetMasterAccountInput) GetMasterAccountRequest {
	op := &aws.Operation{
		Name:       opGetMasterAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/master",
	}

	if input == nil {
		input = &GetMasterAccountInput{}
	}

	req := c.newRequest(op, input, &GetMasterAccountOutput{})
	return GetMasterAccountRequest{Request: req, Input: input, Copy: c.GetMasterAccountRequest}
}

// GetMasterAccountRequest is the request type for the
// GetMasterAccount API operation.
type GetMasterAccountRequest struct {
	*aws.Request
	Input *GetMasterAccountInput
	Copy  func(*GetMasterAccountInput) GetMasterAccountRequest
}

// Send marshals and sends the GetMasterAccount API request.
func (r GetMasterAccountRequest) Send(ctx context.Context) (*GetMasterAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMasterAccountResponse{
		GetMasterAccountOutput: r.Request.Data.(*GetMasterAccountOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMasterAccountResponse is the response type for the
// GetMasterAccount API operation.
type GetMasterAccountResponse struct {
	*GetMasterAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMasterAccount request.
func (r *GetMasterAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
