// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContactRequest
type DescribeContactInput struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	//
	// ContactId is a required field
	ContactId *string `location:"uri" locationName:"contactId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeContactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeContactInput"}

	if s.ContactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeContactInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "contactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContactResponse
type DescribeContactOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	ContactId *string `locationName:"contactId" type:"string"`

	// Status of a contact.
	ContactStatus ContactStatus `locationName:"contactStatus" type:"string" enum:"true"`

	// End time of a contact.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// Error message for a contact.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Ground station for a contact.
	GroundStation *string `locationName:"groundStation" type:"string"`

	// Maximum elevation angle of a contact.
	MaximumElevation *Elevation `locationName:"maximumElevation" type:"structure"`

	// ARN of a mission profile.
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	PostPassEndTime *time.Time `locationName:"postPassEndTime" type:"timestamp" timestampFormat:"unix"`

	// Amount of time prior to contact start you’d like to receive a CloudWatch
	// event indicating an upcoming pass.
	PrePassStartTime *time.Time `locationName:"prePassStartTime" type:"timestamp" timestampFormat:"unix"`

	// ARN of a satellite.
	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	// Start time of a contact.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// Tags assigned to a contact.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeContactOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeContactOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContactId != nil {
		v := *s.ContactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ContactStatus) > 0 {
		v := s.ContactStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contactStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroundStation != nil {
		v := *s.GroundStation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groundStation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaximumElevation != nil {
		v := s.MaximumElevation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "maximumElevation", v, metadata)
	}
	if s.MissionProfileArn != nil {
		v := *s.MissionProfileArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "missionProfileArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PostPassEndTime != nil {
		v := *s.PostPassEndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "postPassEndTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.PrePassStartTime != nil {
		v := *s.PrePassStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prePassStartTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.SatelliteArn != nil {
		v := *s.SatelliteArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "satelliteArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opDescribeContact = "DescribeContact"

// DescribeContactRequest returns a request value for making API operation for
// AWS Ground Station.
//
// Describes an existing contact.
//
//    // Example sending a request using DescribeContactRequest.
//    req := client.DescribeContactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContact
func (c *Client) DescribeContactRequest(input *DescribeContactInput) DescribeContactRequest {
	op := &aws.Operation{
		Name:       opDescribeContact,
		HTTPMethod: "GET",
		HTTPPath:   "/contact/{contactId}",
	}

	if input == nil {
		input = &DescribeContactInput{}
	}

	req := c.newRequest(op, input, &DescribeContactOutput{})
	return DescribeContactRequest{Request: req, Input: input, Copy: c.DescribeContactRequest}
}

// DescribeContactRequest is the request type for the
// DescribeContact API operation.
type DescribeContactRequest struct {
	*aws.Request
	Input *DescribeContactInput
	Copy  func(*DescribeContactInput) DescribeContactRequest
}

// Send marshals and sends the DescribeContact API request.
func (r DescribeContactRequest) Send(ctx context.Context) (*DescribeContactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeContactResponse{
		DescribeContactOutput: r.Request.Data.(*DescribeContactOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeContactResponse is the response type for the
// DescribeContact API operation.
type DescribeContactResponse struct {
	*DescribeContactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeContact request.
func (r *DescribeContactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
