// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthorityRequest
type GetGroupCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// CertificateAuthorityId is a required field
	CertificateAuthorityId *string `location:"uri" locationName:"CertificateAuthorityId" type:"string" required:"true"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupCertificateAuthorityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetGroupCertificateAuthorityInput"}

	if s.CertificateAuthorityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateAuthorityId"))
	}

	if s.GroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGroupCertificateAuthorityInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.CertificateAuthorityId != nil {
		v := *s.CertificateAuthorityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "CertificateAuthorityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "GroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a certificate authority for a group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthorityResponse
type GetGroupCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate authority for the group.
	GroupCertificateAuthorityArn *string `type:"string"`

	// The ID of the certificate authority for the group.
	GroupCertificateAuthorityId *string `type:"string"`

	// The PEM encoded certificate for the group.
	PemEncodedCertificate *string `type:"string"`
}

// String returns the string representation
func (s GetGroupCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGroupCertificateAuthorityOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupCertificateAuthorityArn != nil {
		v := *s.GroupCertificateAuthorityArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupCertificateAuthorityArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupCertificateAuthorityId != nil {
		v := *s.GroupCertificateAuthorityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupCertificateAuthorityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PemEncodedCertificate != nil {
		v := *s.PemEncodedCertificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PemEncodedCertificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetGroupCertificateAuthority = "GetGroupCertificateAuthority"

// GetGroupCertificateAuthorityRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Retreives the CA associated with a group. Returns the public key of the CA.
//
//    // Example sending a request using GetGroupCertificateAuthorityRequest.
//    req := client.GetGroupCertificateAuthorityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority
func (c *Client) GetGroupCertificateAuthorityRequest(input *GetGroupCertificateAuthorityInput) GetGroupCertificateAuthorityRequest {
	op := &aws.Operation{
		Name:       opGetGroupCertificateAuthority,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities/{CertificateAuthorityId}",
	}

	if input == nil {
		input = &GetGroupCertificateAuthorityInput{}
	}

	req := c.newRequest(op, input, &GetGroupCertificateAuthorityOutput{})
	return GetGroupCertificateAuthorityRequest{Request: req, Input: input, Copy: c.GetGroupCertificateAuthorityRequest}
}

// GetGroupCertificateAuthorityRequest is the request type for the
// GetGroupCertificateAuthority API operation.
type GetGroupCertificateAuthorityRequest struct {
	*aws.Request
	Input *GetGroupCertificateAuthorityInput
	Copy  func(*GetGroupCertificateAuthorityInput) GetGroupCertificateAuthorityRequest
}

// Send marshals and sends the GetGroupCertificateAuthority API request.
func (r GetGroupCertificateAuthorityRequest) Send(ctx context.Context) (*GetGroupCertificateAuthorityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGroupCertificateAuthorityResponse{
		GetGroupCertificateAuthorityOutput: r.Request.Data.(*GetGroupCertificateAuthorityOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGroupCertificateAuthorityResponse is the response type for the
// GetGroupCertificateAuthority API operation.
type GetGroupCertificateAuthorityResponse struct {
	*GetGroupCertificateAuthorityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGroupCertificateAuthority request.
func (r *GetGroupCertificateAuthorityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
