// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinitionRequest
type DeleteFunctionDefinitionInput struct {
	_ struct{} `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFunctionDefinitionInput"}

	if s.FunctionDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.FunctionDefinitionId != nil {
		v := *s.FunctionDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinitionResponse
type DeleteFunctionDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteFunctionDefinition = "DeleteFunctionDefinition"

// DeleteFunctionDefinitionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Deletes a Lambda function definition.
//
//    // Example sending a request using DeleteFunctionDefinitionRequest.
//    req := client.DeleteFunctionDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition
func (c *Client) DeleteFunctionDefinitionRequest(input *DeleteFunctionDefinitionInput) DeleteFunctionDefinitionRequest {
	op := &aws.Operation{
		Name:       opDeleteFunctionDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}",
	}

	if input == nil {
		input = &DeleteFunctionDefinitionInput{}
	}

	req := c.newRequest(op, input, &DeleteFunctionDefinitionOutput{})
	return DeleteFunctionDefinitionRequest{Request: req, Input: input, Copy: c.DeleteFunctionDefinitionRequest}
}

// DeleteFunctionDefinitionRequest is the request type for the
// DeleteFunctionDefinition API operation.
type DeleteFunctionDefinitionRequest struct {
	*aws.Request
	Input *DeleteFunctionDefinitionInput
	Copy  func(*DeleteFunctionDefinitionInput) DeleteFunctionDefinitionRequest
}

// Send marshals and sends the DeleteFunctionDefinition API request.
func (r DeleteFunctionDefinitionRequest) Send(ctx context.Context) (*DeleteFunctionDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFunctionDefinitionResponse{
		DeleteFunctionDefinitionOutput: r.Request.Data.(*DeleteFunctionDefinitionOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFunctionDefinitionResponse is the response type for the
// DeleteFunctionDefinition API operation.
type DeleteFunctionDefinitionResponse struct {
	*DeleteFunctionDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFunctionDefinition request.
func (r *DeleteFunctionDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
