// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunctionRequest
type UpdateUserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the function to be updated is located. If
	// none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the function to be updated is located.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A FunctionInput object that re-defines the function in the Data Catalog.
	//
	// FunctionInput is a required field
	FunctionInput *UserDefinedFunctionInput `type:"structure" required:"true"`

	// The name of the function.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserDefinedFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateUserDefinedFunctionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.FunctionInput == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionInput"))
	}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionInput != nil {
		if err := s.FunctionInput.Validate(); err != nil {
			invalidParams.AddNested("FunctionInput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunctionResponse
type UpdateUserDefinedFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserDefinedFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateUserDefinedFunction = "UpdateUserDefinedFunction"

// UpdateUserDefinedFunctionRequest returns a request value for making API operation for
// AWS Glue.
//
// Updates an existing function definition in the Data Catalog.
//
//    // Example sending a request using UpdateUserDefinedFunctionRequest.
//    req := client.UpdateUserDefinedFunctionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunction
func (c *Client) UpdateUserDefinedFunctionRequest(input *UpdateUserDefinedFunctionInput) UpdateUserDefinedFunctionRequest {
	op := &aws.Operation{
		Name:       opUpdateUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserDefinedFunctionInput{}
	}

	req := c.newRequest(op, input, &UpdateUserDefinedFunctionOutput{})
	return UpdateUserDefinedFunctionRequest{Request: req, Input: input, Copy: c.UpdateUserDefinedFunctionRequest}
}

// UpdateUserDefinedFunctionRequest is the request type for the
// UpdateUserDefinedFunction API operation.
type UpdateUserDefinedFunctionRequest struct {
	*aws.Request
	Input *UpdateUserDefinedFunctionInput
	Copy  func(*UpdateUserDefinedFunctionInput) UpdateUserDefinedFunctionRequest
}

// Send marshals and sends the UpdateUserDefinedFunction API request.
func (r UpdateUserDefinedFunctionRequest) Send(ctx context.Context) (*UpdateUserDefinedFunctionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateUserDefinedFunctionResponse{
		UpdateUserDefinedFunctionOutput: r.Request.Data.(*UpdateUserDefinedFunctionOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateUserDefinedFunctionResponse is the response type for the
// UpdateUserDefinedFunction API operation.
type UpdateUserDefinedFunctionResponse struct {
	*UpdateUserDefinedFunctionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateUserDefinedFunction request.
func (r *UpdateUserDefinedFunctionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
