// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTriggerRequest
type StartTriggerInput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger to start.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTriggerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartTriggerInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTriggerResponse
type StartTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger that was started.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartTrigger = "StartTrigger"

// StartTriggerRequest returns a request value for making API operation for
// AWS Glue.
//
// Starts an existing trigger. See Triggering Jobs (http://docs.aws.amazon.com/glue/latest/dg/trigger-job.html)
// for information about how different types of trigger are started.
//
//    // Example sending a request using StartTriggerRequest.
//    req := client.StartTriggerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTrigger
func (c *Client) StartTriggerRequest(input *StartTriggerInput) StartTriggerRequest {
	op := &aws.Operation{
		Name:       opStartTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTriggerInput{}
	}

	req := c.newRequest(op, input, &StartTriggerOutput{})
	return StartTriggerRequest{Request: req, Input: input, Copy: c.StartTriggerRequest}
}

// StartTriggerRequest is the request type for the
// StartTrigger API operation.
type StartTriggerRequest struct {
	*aws.Request
	Input *StartTriggerInput
	Copy  func(*StartTriggerInput) StartTriggerRequest
}

// Send marshals and sends the StartTrigger API request.
func (r StartTriggerRequest) Send(ctx context.Context) (*StartTriggerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartTriggerResponse{
		StartTriggerOutput: r.Request.Data.(*StartTriggerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartTriggerResponse is the response type for the
// StartTrigger API operation.
type StartTriggerResponse struct {
	*StartTriggerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartTrigger request.
func (r *StartTriggerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
