// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmarkRequest
type ResetJobBookmarkInput struct {
	_ struct{} `type:"structure"`

	// The name of the job in question.
	//
	// JobName is a required field
	JobName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResetJobBookmarkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetJobBookmarkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResetJobBookmarkInput"}

	if s.JobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmarkResponse
type ResetJobBookmarkOutput struct {
	_ struct{} `type:"structure"`

	// The reset bookmark entry.
	JobBookmarkEntry *JobBookmarkEntry `type:"structure"`
}

// String returns the string representation
func (s ResetJobBookmarkOutput) String() string {
	return awsutil.Prettify(s)
}

const opResetJobBookmark = "ResetJobBookmark"

// ResetJobBookmarkRequest returns a request value for making API operation for
// AWS Glue.
//
// Resets a bookmark entry.
//
//    // Example sending a request using ResetJobBookmarkRequest.
//    req := client.ResetJobBookmarkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmark
func (c *Client) ResetJobBookmarkRequest(input *ResetJobBookmarkInput) ResetJobBookmarkRequest {
	op := &aws.Operation{
		Name:       opResetJobBookmark,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetJobBookmarkInput{}
	}

	req := c.newRequest(op, input, &ResetJobBookmarkOutput{})
	return ResetJobBookmarkRequest{Request: req, Input: input, Copy: c.ResetJobBookmarkRequest}
}

// ResetJobBookmarkRequest is the request type for the
// ResetJobBookmark API operation.
type ResetJobBookmarkRequest struct {
	*aws.Request
	Input *ResetJobBookmarkInput
	Copy  func(*ResetJobBookmarkInput) ResetJobBookmarkRequest
}

// Send marshals and sends the ResetJobBookmark API request.
func (r ResetJobBookmarkRequest) Send(ctx context.Context) (*ResetJobBookmarkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResetJobBookmarkResponse{
		ResetJobBookmarkOutput: r.Request.Data.(*ResetJobBookmarkOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResetJobBookmarkResponse is the response type for the
// ResetJobBookmark API operation.
type ResetJobBookmarkResponse struct {
	*ResetJobBookmarkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResetJobBookmark request.
func (r *ResetJobBookmarkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
