// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawlerRequest
type DeleteCrawlerInput struct {
	_ struct{} `type:"structure"`

	// The name of the crawler to remove.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCrawlerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCrawlerInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawlerResponse
type DeleteCrawlerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteCrawler = "DeleteCrawler"

// DeleteCrawlerRequest returns a request value for making API operation for
// AWS Glue.
//
// Removes a specified crawler from the AWS Glue Data Catalog, unless the crawler
// state is RUNNING.
//
//    // Example sending a request using DeleteCrawlerRequest.
//    req := client.DeleteCrawlerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler
func (c *Client) DeleteCrawlerRequest(input *DeleteCrawlerInput) DeleteCrawlerRequest {
	op := &aws.Operation{
		Name:       opDeleteCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCrawlerInput{}
	}

	req := c.newRequest(op, input, &DeleteCrawlerOutput{})
	return DeleteCrawlerRequest{Request: req, Input: input, Copy: c.DeleteCrawlerRequest}
}

// DeleteCrawlerRequest is the request type for the
// DeleteCrawler API operation.
type DeleteCrawlerRequest struct {
	*aws.Request
	Input *DeleteCrawlerInput
	Copy  func(*DeleteCrawlerInput) DeleteCrawlerRequest
}

// Send marshals and sends the DeleteCrawler API request.
func (r DeleteCrawlerRequest) Send(ctx context.Context) (*DeleteCrawlerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCrawlerResponse{
		DeleteCrawlerOutput: r.Request.Data.(*DeleteCrawlerOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCrawlerResponse is the response type for the
// DeleteCrawler API operation.
type DeleteCrawlerResponse struct {
	*DeleteCrawlerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCrawler request.
func (r *DeleteCrawlerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
