// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEventsInput
type DescribeFleetEventsInput struct {
	_ struct{} `type:"structure"`

	// Most recent date to retrieve event logs for. If no end time is specified,
	// this call returns entries from the specified start time up to the present.
	// Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a fleet to get event logs for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Earliest date to retrieve event logs for. If no start time is specified,
	// this call returns entries starting from when the fleet was created to the
	// specified end time. Format is a number expressed in Unix time as milliseconds
	// (ex: "1469498468.057").
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DescribeFleetEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeFleetEventsInput"}

	if s.FleetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEventsOutput
type DescribeFleetEventsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing event log entries for the specified fleet.
	Events []Event `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetEventsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeFleetEvents = "DescribeFleetEvents"

// DescribeFleetEventsRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves entries from the specified fleet's event log. You can specify a
// time range to limit the result set. Use the pagination parameters to retrieve
// results as a set of sequential pages. If successful, a collection of event
// log entries matching the request are returned.
//
// Learn more
//
//  Working with Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html).
//
// Related operations
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
//
//    // Example sending a request using DescribeFleetEventsRequest.
//    req := client.DescribeFleetEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents
func (c *Client) DescribeFleetEventsRequest(input *DescribeFleetEventsInput) DescribeFleetEventsRequest {
	op := &aws.Operation{
		Name:       opDescribeFleetEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetEventsInput{}
	}

	req := c.newRequest(op, input, &DescribeFleetEventsOutput{})
	return DescribeFleetEventsRequest{Request: req, Input: input, Copy: c.DescribeFleetEventsRequest}
}

// DescribeFleetEventsRequest is the request type for the
// DescribeFleetEvents API operation.
type DescribeFleetEventsRequest struct {
	*aws.Request
	Input *DescribeFleetEventsInput
	Copy  func(*DescribeFleetEventsInput) DescribeFleetEventsRequest
}

// Send marshals and sends the DescribeFleetEvents API request.
func (r DescribeFleetEventsRequest) Send(ctx context.Context) (*DescribeFleetEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeFleetEventsResponse{
		DescribeFleetEventsOutput: r.Request.Data.(*DescribeFleetEventsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeFleetEventsResponse is the response type for the
// DescribeFleetEvents API operation.
type DescribeFleetEventsResponse struct {
	*DescribeFleetEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeFleetEvents request.
func (r *DescribeFleetEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
