// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// A backup of an Amazon FSx for Windows File Server file system. You can create
// a new file system from a backup to protect against data loss.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/Backup
type Backup struct {
	_ struct{} `type:"structure"`

	// The ID of the backup.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// The time when a particular backup was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Details explaining any failures that occur when creating a backup.
	FailureDetails *BackupFailureDetails `type:"structure"`

	// Metadata of the file system associated with the backup. This metadata is
	// persisted even if the file system is deleted.
	//
	// FileSystem is a required field
	FileSystem *FileSystem `type:"structure" required:"true"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt this
	// backup's data.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the backup.
	//
	// Lifecycle is a required field
	Lifecycle BackupLifecycle `type:"string" required:"true" enum:"true"`

	// The current percent of progress of an asynchronous task.
	ProgressPercent *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for the backup resource.
	ResourceARN *string `min:"8" type:"string"`

	// Tags associated with a particular file system.
	Tags []Tag `min:"1" type:"list"`

	// The type of the backup.
	//
	// Type is a required field
	Type BackupType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Backup) String() string {
	return awsutil.Prettify(s)
}

// If backup creation fails, this structure contains the details of that failure.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/BackupFailureDetails
type BackupFailureDetails struct {
	_ struct{} `type:"structure"`

	// A message describing the backup creation failure.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BackupFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// The configuration object for Lustre file systems used in the CreateFileSystem
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystemLustreConfiguration
type CreateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// (Optional) The path in Amazon S3 where the root of your Amazon FSx file system
	// is exported. The path must use the same Amazon S3 bucket as specified in
	// ImportPath. You can provide an optional prefix to which new and changed data
	// is to be exported from your Amazon FSx for Lustre file system. If an ExportPath
	// value is not provided, Amazon FSx sets a default export path, s3://import-bucket/FSxLustre[creation-timestamp].
	// The timestamp is in UTC format, for example s3://import-bucket/FSxLustre20181105T222312Z.
	//
	// The Amazon S3 export bucket must be the same as the import bucket specified
	// by ImportPath. If you only specify a bucket name, such as s3://import-bucket,
	// you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping
	// means that the input data in S3 is overwritten on export. If you provide
	// a custom prefix in the export path, such as s3://import-bucket/[custom-optional-prefix],
	// Amazon FSx exports the contents of your file system to that export prefix
	// in the Amazon S3 bucket.
	ExportPath *string `min:"3" type:"string"`

	// (Optional) The path to the Amazon S3 bucket (including the optional prefix)
	// that you're using as the data repository for your Amazon FSx for Lustre file
	// system. The root of your FSx for Lustre file system will be mapped to the
	// root of the Amazon S3 bucket you select. An example is s3://import-bucket/optional-prefix.
	// If you specify a prefix after the Amazon S3 bucket name, only object keys
	// with that prefix are loaded into the file system.
	ImportPath *string `min:"3" type:"string"`

	// (Optional) For files imported from a data repository, this value determines
	// the stripe count and maximum amount of data per file (in MiB) stored on a
	// single physical disk. The maximum number of disks that a single file can
	// be striped across is limited by the total number of disks that make up the
	// file system.
	//
	// The chunk size default is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemLustreConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFileSystemLustreConfiguration"}
	if s.ExportPath != nil && len(*s.ExportPath) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("ExportPath", 3))
	}
	if s.ImportPath != nil && len(*s.ImportPath) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("ImportPath", 3))
	}
	if s.ImportedFileChunkSize != nil && *s.ImportedFileChunkSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ImportedFileChunkSize", 1))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration object for the Microsoft Windows file system used in CreateFileSystem
// and CreateFileSystemFromBackup operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateFileSystemWindowsConfiguration
type CreateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing Microsoft Active Directory instance that the file
	// system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. The default is to retain
	// backups for 7 days. Setting this value to 0 disables the creation of automatic
	// backups. The maximum retention period for backups is 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags on the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags on
	// the file system are copied to all automatic backups and any user-initiated
	// backups where the user doesn't specify any tags. If this value is true, and
	// you specify one or more tags, only the specified tags are copied to backups.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second.
	//
	// ThroughputCapacity is a required field
	ThroughputCapacity *int64 `min:"8" type:"integer" required:"true"`

	// The preferred start time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFileSystemWindowsConfiguration"}
	if s.ActiveDirectoryId != nil && len(*s.ActiveDirectoryId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("ActiveDirectoryId", 12))
	}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}

	if s.ThroughputCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThroughputCapacity"))
	}
	if s.ThroughputCapacity != nil && *s.ThroughputCapacity < 8 {
		invalidParams.Add(aws.NewErrParamMinValue("ThroughputCapacity", 8))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The data repository configuration object for Lustre file systems returned
// in the response of the CreateFileSystem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DataRepositoryConfiguration
type DataRepositoryConfiguration struct {
	_ struct{} `type:"structure"`

	// The export path to the Amazon S3 bucket (and prefix) that you are using to
	// store new and changed Lustre file system files in S3.
	ExportPath *string `min:"3" type:"string"`

	// The import path to the Amazon S3 bucket (and optional prefix) that you're
	// using as the data repository for your FSx for Lustre file system, for example
	// s3://import-bucket/optional-prefix. If a prefix is specified after the Amazon
	// S3 bucket name, only object keys with that prefix are loaded into the file
	// system.
	ImportPath *string `min:"3" type:"string"`

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across
	// is limited by the total number of disks that make up the file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DataRepositoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// The configuration object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystemWindowsConfiguration
type DeleteFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// A set of tags for your final backup.
	FinalBackupTags []Tag `min:"1" type:"list"`

	// By default, Amazon FSx for Windows takes a final backup on your behalf when
	// the DeleteFileSystem operation is invoked. Doing this helps protect you from
	// data loss, and we highly recommend taking the final backup. If you want to
	// skip this backup, use this flag to do so.
	SkipFinalBackup *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFileSystemWindowsConfiguration"}
	if s.FinalBackupTags != nil && len(s.FinalBackupTags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FinalBackupTags", 1))
	}
	if s.FinalBackupTags != nil {
		for i, v := range s.FinalBackupTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FinalBackupTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for the Microsoft Windows file system used in the DeleteFileSystem
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/DeleteFileSystemWindowsResponse
type DeleteFileSystemWindowsResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the final backup for this file system.
	FinalBackupId *string `min:"12" type:"string"`

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsResponse) String() string {
	return awsutil.Prettify(s)
}

// A description of a specific Amazon FSx file system.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/FileSystem
type FileSystem struct {
	_ struct{} `type:"structure"`

	// The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The DNS name for the file system.
	DNSName *string `min:"16" type:"string"`

	// Structure providing details of any failures that occur when creating the
	// file system has failed.
	FailureDetails *FileSystemFailureDetails `type:"structure"`

	// The eight-digit ID of the file system that was automatically assigned by
	// Amazon FSx.
	FileSystemId *string `min:"11" type:"string"`

	// Type of file system. Currently the only supported type is WINDOWS.
	FileSystemType FileSystemType `type:"string" enum:"true"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the
	// file system's data for an Amazon FSx for Windows File Server file system.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the file system.
	Lifecycle FileSystemLifecycle `type:"string" enum:"true"`

	// The configuration for the Amazon FSx for Lustre file system.
	LustreConfiguration *LustreFileSystemConfiguration `type:"structure"`

	// The IDs of the elastic network interface from which a specific file system
	// is accessible. The elastic network interface is automatically created in
	// the same VPC that the Amazon FSx file system was created in. For more information,
	// see Elastic Network Interfaces (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html)
	// in the Amazon EC2 User Guide.
	//
	// For an Amazon FSx for Windows File Server file system, you can have one network
	// interface Id. For an Amazon FSx for Lustre file system, you can have more
	// than one.
	NetworkInterfaceIds []string `type:"list"`

	// The AWS account that created the file system. If the file system was created
	// by an IAM user, the AWS account to which the IAM user belongs is the owner.
	OwnerId *string `min:"12" type:"string"`

	// The resource ARN of the file system.
	ResourceARN *string `min:"8" type:"string"`

	// The storage capacity of the file system in gigabytes.
	StorageCapacity *int64 `min:"1" type:"integer"`

	// The IDs of the subnets to contain the endpoint for the file system. One and
	// only one is supported. The file system is launched in the Availability Zone
	// associated with this subnet.
	SubnetIds []string `type:"list"`

	// The tags to associate with the file system. For more information, see Tagging
	// Your Amazon EC2 Resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
	// in the Amazon EC2 User Guide.
	Tags []Tag `min:"1" type:"list"`

	// The ID of the primary VPC for the file system.
	VpcId *string `min:"12" type:"string"`

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *WindowsFileSystemConfiguration `type:"structure"`
}

// String returns the string representation
func (s FileSystem) String() string {
	return awsutil.Prettify(s)
}

// Structure providing details of any failures that occur when creating the
// file system has failed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/FileSystemFailureDetails
type FileSystemFailureDetails struct {
	_ struct{} `type:"structure"`

	// Message describing the failures that occurred during file system creation.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FileSystemFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// A filter used to restrict the results of describe calls. You can use multiple
// filters to return results that meet all applied filter requirements.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// The name for this filter.
	Name FilterName `type:"string" enum:"true"`

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// The configuration for the Amazon FSx for Lustre file system.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/LustreFileSystemConfiguration
type LustreFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The data repository configuration object for Lustre file systems returned
	// in the response of the CreateFileSystem operation.
	DataRepositoryConfiguration *DataRepositoryConfiguration `type:"structure"`

	// The UTC time that you want to begin your weekly maintenance window.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s LustreFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Specifies a key-value pair for a resource tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// A value that specifies the TagKey, the name of the tag. Tag keys must be
	// unique for the resource to which they are attached.
	Key *string `min:"1" type:"string"`

	// A value that specifies the TagValue, the value assigned to the corresponding
	// tag key. Tag values can be null and don't have to be unique in a tag set.
	// For example, you can have a key-value pair in a tag set of finances : April
	// and also of payroll : April.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration object for Amazon FSx for Lustre file systems used in the
// UpdateFileSystem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystemLustreConfiguration
type UpdateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemLustreConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFileSystemLustreConfiguration"}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration object for the Microsoft Windows file system used in the
// UpdateFileSystem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystemWindowsConfiguration
type UpdateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFileSystemWindowsConfiguration"}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration for this Microsoft Windows file system.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/WindowsFileSystemConfiguration
type WindowsFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing Microsoft Active Directory instance that the file
	// system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags on the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags on
	// the file system are copied to all automatic backups and any user-initiated
	// backups where the user doesn't specify any tags. If this value is true, and
	// you specify one or more tags, only the specified tags are copied to backups.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The list of maintenance operations in progress for this file system.
	MaintenanceOperationsInProgress []FileSystemMaintenanceOperation `type:"list"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second.
	ThroughputCapacity *int64 `min:"8" type:"integer"`

	// The preferred time to perform weekly maintenance, in the UTC time zone.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s WindowsFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}
