// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurationsInput
type ListSecurityConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListSecurityConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurationsOutput
type ListSecurityConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that indicates the next set of results to retrieve. Include
	// the marker in the next ListSecurityConfiguration call to retrieve the next
	// page of results, if required.
	Marker *string `type:"string"`

	// The creation date and time, and name, of each security configuration.
	SecurityConfigurations []SecurityConfigurationSummary `type:"list"`
}

// String returns the string representation
func (s ListSecurityConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListSecurityConfigurations = "ListSecurityConfigurations"

// ListSecurityConfigurationsRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Lists all the security configurations visible to this account, providing
// their creation dates and times, and their names. This call returns a maximum
// of 50 clusters per call, but returns a marker to track the paging of the
// cluster list across multiple ListSecurityConfigurations calls.
//
//    // Example sending a request using ListSecurityConfigurationsRequest.
//    req := client.ListSecurityConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations
func (c *Client) ListSecurityConfigurationsRequest(input *ListSecurityConfigurationsInput) ListSecurityConfigurationsRequest {
	op := &aws.Operation{
		Name:       opListSecurityConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityConfigurationsInput{}
	}

	req := c.newRequest(op, input, &ListSecurityConfigurationsOutput{})
	return ListSecurityConfigurationsRequest{Request: req, Input: input, Copy: c.ListSecurityConfigurationsRequest}
}

// ListSecurityConfigurationsRequest is the request type for the
// ListSecurityConfigurations API operation.
type ListSecurityConfigurationsRequest struct {
	*aws.Request
	Input *ListSecurityConfigurationsInput
	Copy  func(*ListSecurityConfigurationsInput) ListSecurityConfigurationsRequest
}

// Send marshals and sends the ListSecurityConfigurations API request.
func (r ListSecurityConfigurationsRequest) Send(ctx context.Context) (*ListSecurityConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSecurityConfigurationsResponse{
		ListSecurityConfigurationsOutput: r.Request.Data.(*ListSecurityConfigurationsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSecurityConfigurationsRequestPaginator returns a paginator for ListSecurityConfigurations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSecurityConfigurationsRequest(input)
//   p := emr.NewListSecurityConfigurationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSecurityConfigurationsPaginator(req ListSecurityConfigurationsRequest) ListSecurityConfigurationsPaginator {
	return ListSecurityConfigurationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSecurityConfigurationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSecurityConfigurationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSecurityConfigurationsPaginator struct {
	aws.Pager
}

func (p *ListSecurityConfigurationsPaginator) CurrentPage() *ListSecurityConfigurationsOutput {
	return p.Pager.CurrentPage().(*ListSecurityConfigurationsOutput)
}

// ListSecurityConfigurationsResponse is the response type for the
// ListSecurityConfigurations API operation.
type ListSecurityConfigurationsResponse struct {
	*ListSecurityConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSecurityConfigurations request.
func (r *ListSecurityConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
