// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The input argument to the CancelSteps operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelStepsInput
type CancelStepsInput struct {
	_ struct{} `type:"structure"`

	// The ClusterID for which specified steps will be canceled. Use RunJobFlow
	// and ListClusters to get ClusterIDs.
	ClusterId *string `type:"string"`

	// The list of StepIDs to cancel. Use ListSteps to get steps and their states
	// for the specified cluster.
	StepIds []string `type:"list"`
}

// String returns the string representation
func (s CancelStepsInput) String() string {
	return awsutil.Prettify(s)
}

// The output for the CancelSteps operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelStepsOutput
type CancelStepsOutput struct {
	_ struct{} `type:"structure"`

	// A list of CancelStepsInfo, which shows the status of specified cancel requests
	// for each StepID specified.
	CancelStepsInfoList []CancelStepsInfo `type:"list"`
}

// String returns the string representation
func (s CancelStepsOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelSteps = "CancelSteps"

// CancelStepsRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Cancels a pending step or steps in a running cluster. Available only in Amazon
// EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps
// are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous;
// it does not guarantee a step will be canceled, even if the request is successfully
// submitted. You can only cancel steps that are in a PENDING state.
//
//    // Example sending a request using CancelStepsRequest.
//    req := client.CancelStepsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelSteps
func (c *Client) CancelStepsRequest(input *CancelStepsInput) CancelStepsRequest {
	op := &aws.Operation{
		Name:       opCancelSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelStepsInput{}
	}

	req := c.newRequest(op, input, &CancelStepsOutput{})
	return CancelStepsRequest{Request: req, Input: input, Copy: c.CancelStepsRequest}
}

// CancelStepsRequest is the request type for the
// CancelSteps API operation.
type CancelStepsRequest struct {
	*aws.Request
	Input *CancelStepsInput
	Copy  func(*CancelStepsInput) CancelStepsRequest
}

// Send marshals and sends the CancelSteps API request.
func (r CancelStepsRequest) Send(ctx context.Context) (*CancelStepsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelStepsResponse{
		CancelStepsOutput: r.Request.Data.(*CancelStepsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelStepsResponse is the response type for the
// CancelSteps API operation.
type CancelStepsResponse struct {
	*CancelStepsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelSteps request.
func (r *CancelStepsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
