// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elastictranscoder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The DeletePipelineRequest structure.
type DeletePipelineInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pipeline that you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipelineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePipelineInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePipelineInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The DeletePipelineResponse structure.
type DeletePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePipelineOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest returns a request value for making API operation for
// Amazon Elastic Transcoder.
//
// The DeletePipeline operation removes a pipeline.
//
// You can only delete a pipeline that has never been used or that is not currently
// in use (doesn't contain any active jobs). If the pipeline is currently in
// use, DeletePipeline returns an error.
//
//    // Example sending a request using DeletePipelineRequest.
//    req := client.DeletePipelineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeletePipelineRequest(input *DeletePipelineInput) DeletePipelineRequest {
	op := &aws.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2012-09-25/pipelines/{Id}",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	req := c.newRequest(op, input, &DeletePipelineOutput{})
	return DeletePipelineRequest{Request: req, Input: input, Copy: c.DeletePipelineRequest}
}

// DeletePipelineRequest is the request type for the
// DeletePipeline API operation.
type DeletePipelineRequest struct {
	*aws.Request
	Input *DeletePipelineInput
	Copy  func(*DeletePipelineInput) DeletePipelineRequest
}

// Send marshals and sends the DeletePipeline API request.
func (r DeletePipelineRequest) Send(ctx context.Context) (*DeletePipelineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePipelineResponse{
		DeletePipelineOutput: r.Request.Data.(*DeletePipelineOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePipelineResponse is the response type for the
// DeletePipeline API operation.
type DeletePipelineResponse struct {
	*DeletePipelineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePipeline request.
func (r *DeletePipelineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
