// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTagsInput
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArns is a required field
	ResourceArns []string `type:"list" required:"true"`

	// The tag keys for the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveTagsInput"}

	if s.ResourceArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArns"))
	}

	if s.TagKeys == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTagsOutput
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Removes the specified tags from the specified Elastic Load Balancing resource.
//
// To list the current tags for your resources, use DescribeTags.
//
//    // Example sending a request using RemoveTagsRequest.
//    req := client.RemoveTagsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTags
func (c *Client) RemoveTagsRequest(input *RemoveTagsInput) RemoveTagsRequest {
	op := &aws.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req := c.newRequest(op, input, &RemoveTagsOutput{})
	return RemoveTagsRequest{Request: req, Input: input, Copy: c.RemoveTagsRequest}
}

// RemoveTagsRequest is the request type for the
// RemoveTags API operation.
type RemoveTagsRequest struct {
	*aws.Request
	Input *RemoveTagsInput
	Copy  func(*RemoveTagsInput) RemoveTagsRequest
}

// Send marshals and sends the RemoveTags API request.
func (r RemoveTagsRequest) Send(ctx context.Context) (*RemoveTagsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveTagsResponse{
		RemoveTagsOutput: r.Request.Data.(*RemoveTagsOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveTagsResponse is the response type for the
// RemoveTags API operation.
type RemoveTagsResponse struct {
	*RemoveTagsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveTags request.
func (r *RemoveTagsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
