// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSettingRequest
type PutAccountSettingInput struct {
	_ struct{} `type:"structure"`

	// The resource name for which to enable the new format. If serviceLongArnFormat
	// is specified, the ARN for your Amazon ECS services is affected. If taskLongArnFormat
	// is specified, the ARN and resource ID for your Amazon ECS tasks is affected.
	// If containerInstanceLongArnFormat is specified, the ARN and resource ID for
	// your Amazon ECS container instances is affected.
	//
	// Name is a required field
	Name SettingName `locationName:"name" type:"string" required:"true" enum:"true"`

	// The ARN of the principal, which can be an IAM user, IAM role, or the root
	// user. If you specify the root user, it modifies the ARN and resource ID format
	// for all IAM users, IAM roles, and the root user of the account unless an
	// IAM user or role explicitly overrides these settings for themselves. If this
	// field is omitted, the settings are changed only for the authenticated user.
	PrincipalArn *string `locationName:"principalArn" type:"string"`

	// The account setting value for the specified principal ARN. Accepted values
	// are enabled and disabled.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s PutAccountSettingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccountSettingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutAccountSettingInput"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSettingResponse
type PutAccountSettingOutput struct {
	_ struct{} `type:"structure"`

	// The current account setting for a resource.
	Setting *Setting `locationName:"setting" type:"structure"`
}

// String returns the string representation
func (s PutAccountSettingOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutAccountSetting = "PutAccountSetting"

// PutAccountSettingRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Modifies the ARN and resource ID format of a resource type for a specified
// IAM user, IAM role, or the root user for an account. If the account setting
// for the root user is changed, it sets the default setting for all of the
// IAM users and roles for which no individual account setting has been set.
// The opt-in and opt-out account setting can be set for each Amazon ECS resource
// separately. The ARN and resource ID format of a resource will be defined
// by the opt-in status of the IAM user or role that created the resource. Enabling
// this setting is required to use new Amazon ECS features such as resource
// tagging. For more information, see Amazon Resource Names (ARNs) and IDs (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-resource-ids.html)
// in the Amazon Elastic Container Service Developer Guide.
//
//    // Example sending a request using PutAccountSettingRequest.
//    req := client.PutAccountSettingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAccountSetting
func (c *Client) PutAccountSettingRequest(input *PutAccountSettingInput) PutAccountSettingRequest {
	op := &aws.Operation{
		Name:       opPutAccountSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAccountSettingInput{}
	}

	req := c.newRequest(op, input, &PutAccountSettingOutput{})
	return PutAccountSettingRequest{Request: req, Input: input, Copy: c.PutAccountSettingRequest}
}

// PutAccountSettingRequest is the request type for the
// PutAccountSetting API operation.
type PutAccountSettingRequest struct {
	*aws.Request
	Input *PutAccountSettingInput
	Copy  func(*PutAccountSettingInput) PutAccountSettingRequest
}

// Send marshals and sends the PutAccountSetting API request.
func (r PutAccountSettingRequest) Send(ctx context.Context) (*PutAccountSettingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutAccountSettingResponse{
		PutAccountSettingOutput: r.Request.Data.(*PutAccountSettingOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutAccountSettingResponse is the response type for the
// PutAccountSetting API operation.
type PutAccountSettingResponse struct {
	*PutAccountSettingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutAccountSetting request.
func (r *PutAccountSettingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
