// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ExportClientVpnClientConfigurationRequest
type ExportClientVpnClientConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Client VPN endpoint.
	//
	// ClientVpnEndpointId is a required field
	ClientVpnEndpointId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`
}

// String returns the string representation
func (s ExportClientVpnClientConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportClientVpnClientConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportClientVpnClientConfigurationInput"}

	if s.ClientVpnEndpointId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientVpnEndpointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ExportClientVpnClientConfigurationResult
type ExportClientVpnClientConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the Client VPN endpoint configuration file.
	ClientConfiguration *string `locationName:"clientConfiguration" type:"string"`
}

// String returns the string representation
func (s ExportClientVpnClientConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opExportClientVpnClientConfiguration = "ExportClientVpnClientConfiguration"

// ExportClientVpnClientConfigurationRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Downloads the contents of the Client VPN endpoint configuration file for
// the specified Client VPN endpoint. The Client VPN endpoint configuration
// file includes the Client VPN endpoint and certificate information clients
// need to establish a connection with the Client VPN endpoint.
//
//    // Example sending a request using ExportClientVpnClientConfigurationRequest.
//    req := client.ExportClientVpnClientConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ExportClientVpnClientConfiguration
func (c *Client) ExportClientVpnClientConfigurationRequest(input *ExportClientVpnClientConfigurationInput) ExportClientVpnClientConfigurationRequest {
	op := &aws.Operation{
		Name:       opExportClientVpnClientConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportClientVpnClientConfigurationInput{}
	}

	req := c.newRequest(op, input, &ExportClientVpnClientConfigurationOutput{})
	return ExportClientVpnClientConfigurationRequest{Request: req, Input: input, Copy: c.ExportClientVpnClientConfigurationRequest}
}

// ExportClientVpnClientConfigurationRequest is the request type for the
// ExportClientVpnClientConfiguration API operation.
type ExportClientVpnClientConfigurationRequest struct {
	*aws.Request
	Input *ExportClientVpnClientConfigurationInput
	Copy  func(*ExportClientVpnClientConfigurationInput) ExportClientVpnClientConfigurationRequest
}

// Send marshals and sends the ExportClientVpnClientConfiguration API request.
func (r ExportClientVpnClientConfigurationRequest) Send(ctx context.Context) (*ExportClientVpnClientConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ExportClientVpnClientConfigurationResponse{
		ExportClientVpnClientConfigurationOutput: r.Request.Data.(*ExportClientVpnClientConfigurationOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ExportClientVpnClientConfigurationResponse is the response type for the
// ExportClientVpnClientConfiguration API operation.
type ExportClientVpnClientConfigurationResponse struct {
	*ExportClientVpnClientConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ExportClientVpnClientConfiguration request.
func (r *ExportClientVpnClientConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
