// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeSpotFleetRequests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestsRequest
type DescribeSpotFleetRequestsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The maximum number of results to return in a single call. Specify a value
	// between 1 and 1000. The default value is 1000. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The IDs of the Spot Fleet requests.
	SpotFleetRequestIds []string `locationName:"spotFleetRequestId" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSpotFleetRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of DescribeSpotFleetRequests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestsResponse
type DescribeSpotFleetRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the configuration of your Spot Fleet.
	SpotFleetRequestConfigs []SpotFleetRequestConfig `locationName:"spotFleetRequestConfigSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeSpotFleetRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSpotFleetRequests = "DescribeSpotFleetRequests"

// DescribeSpotFleetRequestsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes your Spot Fleet requests.
//
// Spot Fleet requests are deleted 48 hours after they are canceled and their
// instances are terminated.
//
//    // Example sending a request using DescribeSpotFleetRequestsRequest.
//    req := client.DescribeSpotFleetRequestsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests
func (c *Client) DescribeSpotFleetRequestsRequest(input *DescribeSpotFleetRequestsInput) DescribeSpotFleetRequestsRequest {
	op := &aws.Operation{
		Name:       opDescribeSpotFleetRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSpotFleetRequestsInput{}
	}

	req := c.newRequest(op, input, &DescribeSpotFleetRequestsOutput{})
	return DescribeSpotFleetRequestsRequest{Request: req, Input: input, Copy: c.DescribeSpotFleetRequestsRequest}
}

// DescribeSpotFleetRequestsRequest is the request type for the
// DescribeSpotFleetRequests API operation.
type DescribeSpotFleetRequestsRequest struct {
	*aws.Request
	Input *DescribeSpotFleetRequestsInput
	Copy  func(*DescribeSpotFleetRequestsInput) DescribeSpotFleetRequestsRequest
}

// Send marshals and sends the DescribeSpotFleetRequests API request.
func (r DescribeSpotFleetRequestsRequest) Send(ctx context.Context) (*DescribeSpotFleetRequestsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSpotFleetRequestsResponse{
		DescribeSpotFleetRequestsOutput: r.Request.Data.(*DescribeSpotFleetRequestsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeSpotFleetRequestsRequestPaginator returns a paginator for DescribeSpotFleetRequests.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeSpotFleetRequestsRequest(input)
//   p := ec2.NewDescribeSpotFleetRequestsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeSpotFleetRequestsPaginator(req DescribeSpotFleetRequestsRequest) DescribeSpotFleetRequestsPaginator {
	return DescribeSpotFleetRequestsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeSpotFleetRequestsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeSpotFleetRequestsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeSpotFleetRequestsPaginator struct {
	aws.Pager
}

func (p *DescribeSpotFleetRequestsPaginator) CurrentPage() *DescribeSpotFleetRequestsOutput {
	return p.Pager.CurrentPage().(*DescribeSpotFleetRequestsOutput)
}

// DescribeSpotFleetRequestsResponse is the response type for the
// DescribeSpotFleetRequests API operation.
type DescribeSpotFleetRequestsResponse struct {
	*DescribeSpotFleetRequestsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSpotFleetRequests request.
func (r *DescribeSpotFleetRequestsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
