// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecificationsRequest
type DescribeInstanceCreditSpecificationsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The filters.
	//
	//    * instance-id - The ID of the instance.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The instance IDs.
	//
	// Default: Describes all your instances.
	//
	// Constraints: Maximum 1000 explicitly specified instance IDs.
	InstanceIds []string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value. This
	// value can be between 5 and 1000. You cannot specify this parameter and the
	// instance IDs parameter in the same call.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceCreditSpecificationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceCreditSpecificationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeInstanceCreditSpecificationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecificationsResult
type DescribeInstanceCreditSpecificationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the credit option for CPU usage of an instance.
	InstanceCreditSpecifications []InstanceCreditSpecification `locationName:"instanceCreditSpecificationSet" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeInstanceCreditSpecificationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInstanceCreditSpecifications = "DescribeInstanceCreditSpecifications"

// DescribeInstanceCreditSpecificationsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes the credit option for CPU usage of the specified T2 or T3 instances.
// The credit options are standard and unlimited.
//
// If you do not specify an instance ID, Amazon EC2 returns T2 and T3 instances
// with the unlimited credit option, as well as instances that were previously
// configured as T2 or T3 with the unlimited credit option. For example, if
// you resize a T2 instance, while it is configured as unlimited, to an M4 instance,
// Amazon EC2 returns the M4 instance.
//
// If you specify one or more instance IDs, Amazon EC2 returns the credit option
// (standard or unlimited) of those instances. If you specify an instance ID
// that is not valid, such as an instance that is not a T2 or T3 instance, an
// error is returned.
//
// Recently terminated instances might appear in the returned results. This
// interval is usually less than one hour.
//
// If an Availability Zone is experiencing a service disruption and you specify
// instance IDs in the affected zone, or do not specify any instance IDs at
// all, the call fails. If you specify only instance IDs in an unaffected zone,
// the call works normally.
//
// For more information, see Burstable Performance Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using DescribeInstanceCreditSpecificationsRequest.
//    req := client.DescribeInstanceCreditSpecificationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications
func (c *Client) DescribeInstanceCreditSpecificationsRequest(input *DescribeInstanceCreditSpecificationsInput) DescribeInstanceCreditSpecificationsRequest {
	op := &aws.Operation{
		Name:       opDescribeInstanceCreditSpecifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceCreditSpecificationsInput{}
	}

	req := c.newRequest(op, input, &DescribeInstanceCreditSpecificationsOutput{})
	return DescribeInstanceCreditSpecificationsRequest{Request: req, Input: input, Copy: c.DescribeInstanceCreditSpecificationsRequest}
}

// DescribeInstanceCreditSpecificationsRequest is the request type for the
// DescribeInstanceCreditSpecifications API operation.
type DescribeInstanceCreditSpecificationsRequest struct {
	*aws.Request
	Input *DescribeInstanceCreditSpecificationsInput
	Copy  func(*DescribeInstanceCreditSpecificationsInput) DescribeInstanceCreditSpecificationsRequest
}

// Send marshals and sends the DescribeInstanceCreditSpecifications API request.
func (r DescribeInstanceCreditSpecificationsRequest) Send(ctx context.Context) (*DescribeInstanceCreditSpecificationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInstanceCreditSpecificationsResponse{
		DescribeInstanceCreditSpecificationsOutput: r.Request.Data.(*DescribeInstanceCreditSpecificationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeInstanceCreditSpecificationsRequestPaginator returns a paginator for DescribeInstanceCreditSpecifications.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeInstanceCreditSpecificationsRequest(input)
//   p := ec2.NewDescribeInstanceCreditSpecificationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeInstanceCreditSpecificationsPaginator(req DescribeInstanceCreditSpecificationsRequest) DescribeInstanceCreditSpecificationsPaginator {
	return DescribeInstanceCreditSpecificationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeInstanceCreditSpecificationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeInstanceCreditSpecificationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeInstanceCreditSpecificationsPaginator struct {
	aws.Pager
}

func (p *DescribeInstanceCreditSpecificationsPaginator) CurrentPage() *DescribeInstanceCreditSpecificationsOutput {
	return p.Pager.CurrentPage().(*DescribeInstanceCreditSpecificationsOutput)
}

// DescribeInstanceCreditSpecificationsResponse is the response type for the
// DescribeInstanceCreditSpecifications API operation.
type DescribeInstanceCreditSpecificationsResponse struct {
	*DescribeInstanceCreditSpecificationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInstanceCreditSpecifications request.
func (r *DescribeInstanceCreditSpecificationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
