// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurationsRequest
type DeleteVpcEndpointServiceConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IDs of one or more services.
	//
	// ServiceIds is a required field
	ServiceIds []string `locationName:"ServiceId" locationNameList:"item" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteVpcEndpointServiceConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcEndpointServiceConfigurationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVpcEndpointServiceConfigurationsInput"}

	if s.ServiceIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurationsResult
type DeleteVpcEndpointServiceConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the service configurations that were not deleted, if applicable.
	Unsuccessful []UnsuccessfulItem `locationName:"unsuccessful" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DeleteVpcEndpointServiceConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVpcEndpointServiceConfigurations = "DeleteVpcEndpointServiceConfigurations"

// DeleteVpcEndpointServiceConfigurationsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes one or more VPC endpoint service configurations in your account.
// Before you delete the endpoint service configuration, you must reject any
// Available or PendingAcceptance interface endpoint connections that are attached
// to the service.
//
//    // Example sending a request using DeleteVpcEndpointServiceConfigurationsRequest.
//    req := client.DeleteVpcEndpointServiceConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations
func (c *Client) DeleteVpcEndpointServiceConfigurationsRequest(input *DeleteVpcEndpointServiceConfigurationsInput) DeleteVpcEndpointServiceConfigurationsRequest {
	op := &aws.Operation{
		Name:       opDeleteVpcEndpointServiceConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointServiceConfigurationsInput{}
	}

	req := c.newRequest(op, input, &DeleteVpcEndpointServiceConfigurationsOutput{})
	return DeleteVpcEndpointServiceConfigurationsRequest{Request: req, Input: input, Copy: c.DeleteVpcEndpointServiceConfigurationsRequest}
}

// DeleteVpcEndpointServiceConfigurationsRequest is the request type for the
// DeleteVpcEndpointServiceConfigurations API operation.
type DeleteVpcEndpointServiceConfigurationsRequest struct {
	*aws.Request
	Input *DeleteVpcEndpointServiceConfigurationsInput
	Copy  func(*DeleteVpcEndpointServiceConfigurationsInput) DeleteVpcEndpointServiceConfigurationsRequest
}

// Send marshals and sends the DeleteVpcEndpointServiceConfigurations API request.
func (r DeleteVpcEndpointServiceConfigurationsRequest) Send(ctx context.Context) (*DeleteVpcEndpointServiceConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVpcEndpointServiceConfigurationsResponse{
		DeleteVpcEndpointServiceConfigurationsOutput: r.Request.Data.(*DeleteVpcEndpointServiceConfigurationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVpcEndpointServiceConfigurationsResponse is the response type for the
// DeleteVpcEndpointServiceConfigurations API operation.
type DeleteVpcEndpointServiceConfigurationsResponse struct {
	*DeleteVpcEndpointServiceConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVpcEndpointServiceConfigurations request.
func (r *DeleteVpcEndpointServiceConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
