// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Represents an attribute for describing the key schema for the table and indexes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AttributeDefinition
type AttributeDefinition struct {
	_ struct{} `type:"structure"`

	// A name for the attribute.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The data type for the attribute, where:
	//
	//    * S - the attribute is of type String
	//
	//    * N - the attribute is of type Number
	//
	//    * B - the attribute is of type Binary
	//
	// AttributeType is a required field
	AttributeType ScalarAttributeType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeDefinition"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}
	if len(s.AttributeType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AttributeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the data for an attribute.
//
// Each attribute value is described as a name-value pair. The name is the data
// type, and the value is the data itself.
//
// For more information, see Data Types (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
// in the Amazon DynamoDB Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AttributeValue
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// An attribute of type Binary. For example:
	//
	// "B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
	//
	// B is automatically base64 encoded/decoded by the SDK.
	B []byte `type:"blob"`

	// An attribute of type Boolean. For example:
	//
	// "BOOL": true
	BOOL *bool `type:"boolean"`

	// An attribute of type Binary Set. For example:
	//
	// "BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]
	BS [][]byte `type:"list"`

	// An attribute of type List. For example:
	//
	// "L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]
	L []AttributeValue `type:"list"`

	// An attribute of type Map. For example:
	//
	// "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
	M map[string]AttributeValue `type:"map"`

	// An attribute of type Number. For example:
	//
	// "N": "123.45"
	//
	// Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
	// across languages and libraries. However, DynamoDB treats them as number type
	// attributes for mathematical operations.
	N *string `type:"string"`

	// An attribute of type Number Set. For example:
	//
	// "NS": ["42.2", "-19", "7.5", "3.14"]
	//
	// Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
	// across languages and libraries. However, DynamoDB treats them as number type
	// attributes for mathematical operations.
	NS []string `type:"list"`

	// An attribute of type Null. For example:
	//
	// "NULL": true
	NULL *bool `type:"boolean"`

	// An attribute of type String. For example:
	//
	// "S": "Hello"
	S *string `type:"string"`

	// An attribute of type String Set. For example:
	//
	// "SS": ["Giraffe", "Hippo" ,"Zebra"]
	SS []string `type:"list"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// For the UpdateItem operation, represents the attributes to be modified, the
// action to perform on each, and the new value for each.
//
// You cannot use UpdateItem to update any primary key attributes. Instead,
// you will need to delete the item, and then use PutItem to create a new item
// with new attributes.
//
// Attribute values cannot be null; string and binary type attributes must have
// lengths greater than zero; and set type attributes must not be empty. Requests
// with empty values will be rejected with a ValidationException exception.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AttributeValueUpdate
type AttributeValueUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies how to perform the update. Valid values are PUT (default), DELETE,
	// and ADD. The behavior depends on whether the specified primary key already
	// exists in the table.
	//
	// If an item with the specified Key is found in the table:
	//
	//    * PUT - Adds the specified attribute to the item. If the attribute already
	//    exists, it is replaced by the new value.
	//
	//    * DELETE - If no value is specified, the attribute and its value are removed
	//    from the item. The data type of the specified value must match the existing
	//    value's data type. If a set of values is specified, then those values
	//    are subtracted from the old set. For example, if the attribute value was
	//    the set [a,b,c] and the DELETE action specified [a,c], then the final
	//    attribute value would be [b]. Specifying an empty set is an error.
	//
	//    * ADD - If the attribute does not already exist, then the attribute and
	//    its values are added to the item. If the attribute does exist, then the
	//    behavior of ADD depends on the data type of the attribute: If the existing
	//    attribute is a number, and if Value is also a number, then the Value is
	//    mathematically added to the existing attribute. If Value is a negative
	//    number, then it is subtracted from the existing attribute. If you use
	//    ADD to increment or decrement a number value for an item that doesn't
	//    exist before the update, DynamoDB uses 0 as the initial value. In addition,
	//    if you use ADD to update an existing item, and intend to increment or
	//    decrement an attribute value which does not yet exist, DynamoDB uses 0
	//    as the initial value. For example, suppose that the item you want to update
	//    does not yet have an attribute named itemcount, but you decide to ADD
	//    the number 3 to this attribute anyway, even though it currently does not
	//    exist. DynamoDB will create the itemcount attribute, set its initial value
	//    to 0, and finally add 3 to it. The result will be a new itemcount attribute
	//    in the item, with a value of 3. If the existing data type is a set, and
	//    if the Value is also a set, then the Value is added to the existing set.
	//    (This is a set operation, not mathematical addition.) For example, if
	//    the attribute value was the set [1,2], and the ADD action specified [3],
	//    then the final attribute value would be [1,2,3]. An error occurs if an
	//    Add action is specified for a set attribute and the attribute type specified
	//    does not match the existing set type. Both sets must have the same primitive
	//    data type. For example, if the existing data type is a set of strings,
	//    the Value must also be a set of strings. The same holds true for number
	//    sets and binary sets. This action is only valid for an existing attribute
	//    whose data type is number or is a set. Do not use ADD for any other data
	//    types.
	//
	// If no item with the specified Key is found:
	//
	//    * PUT - DynamoDB creates a new item with the specified primary key, and
	//    then adds the attribute.
	//
	//    * DELETE - Nothing happens; there is no attribute to delete.
	//
	//    * ADD - DynamoDB creates an item with the supplied primary key and number
	//    (or set of numbers) for the attribute value. The only data types allowed
	//    are number and number set; no other data types can be specified.
	Action AttributeAction `type:"string" enum:"true"`

	// Represents the data for an attribute.
	//
	// Each attribute value is described as a name-value pair. The name is the data
	// type, and the value is the data itself.
	//
	// For more information, see Data Types (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
	// in the Amazon DynamoDB Developer Guide.
	Value *AttributeValue `type:"structure"`
}

// String returns the string representation
func (s AttributeValueUpdate) String() string {
	return awsutil.Prettify(s)
}

// Represents the properties of the scaling policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AutoScalingPolicyDescription
type AutoScalingPolicyDescription struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// Represents a target tracking scaling policy configuration.
	TargetTrackingScalingPolicyConfiguration *AutoScalingTargetTrackingScalingPolicyConfigurationDescription `type:"structure"`
}

// String returns the string representation
func (s AutoScalingPolicyDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the autoscaling policy to be modified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AutoScalingPolicyUpdate
type AutoScalingPolicyUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// Represents a target tracking scaling policy configuration.
	//
	// TargetTrackingScalingPolicyConfiguration is a required field
	TargetTrackingScalingPolicyConfiguration *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s AutoScalingPolicyUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingPolicyUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoScalingPolicyUpdate"}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if s.TargetTrackingScalingPolicyConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetTrackingScalingPolicyConfiguration"))
	}
	if s.TargetTrackingScalingPolicyConfiguration != nil {
		if err := s.TargetTrackingScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetTrackingScalingPolicyConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the autoscaling settings for a global table or global secondary
// index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AutoScalingSettingsDescription
type AutoScalingSettingsDescription struct {
	_ struct{} `type:"structure"`

	// Disabled autoscaling for this global table or global secondary index.
	AutoScalingDisabled *bool `type:"boolean"`

	// Role ARN used for configuring autoScaling policy.
	AutoScalingRoleArn *string `type:"string"`

	// The maximum capacity units that a global table or global secondary index
	// should be scaled up to.
	MaximumUnits *int64 `min:"1" type:"long"`

	// The minimum capacity units that a global table or global secondary index
	// should be scaled down to.
	MinimumUnits *int64 `min:"1" type:"long"`

	// Information about the scaling policies.
	ScalingPolicies []AutoScalingPolicyDescription `type:"list"`
}

// String returns the string representation
func (s AutoScalingSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the autoscaling settings to be modified for a global table or
// global secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AutoScalingSettingsUpdate
type AutoScalingSettingsUpdate struct {
	_ struct{} `type:"structure"`

	// Disabled autoscaling for this global table or global secondary index.
	AutoScalingDisabled *bool `type:"boolean"`

	// Role ARN used for configuring autoscaling policy.
	AutoScalingRoleArn *string `min:"1" type:"string"`

	// The maximum capacity units that a global table or global secondary index
	// should be scaled up to.
	MaximumUnits *int64 `min:"1" type:"long"`

	// The minimum capacity units that a global table or global secondary index
	// should be scaled down to.
	MinimumUnits *int64 `min:"1" type:"long"`

	// The scaling policy to apply for scaling target global table or global secondary
	// index capacity units.
	ScalingPolicyUpdate *AutoScalingPolicyUpdate `type:"structure"`
}

// String returns the string representation
func (s AutoScalingSettingsUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingSettingsUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoScalingSettingsUpdate"}
	if s.AutoScalingRoleArn != nil && len(*s.AutoScalingRoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingRoleArn", 1))
	}
	if s.MaximumUnits != nil && *s.MaximumUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaximumUnits", 1))
	}
	if s.MinimumUnits != nil && *s.MinimumUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MinimumUnits", 1))
	}
	if s.ScalingPolicyUpdate != nil {
		if err := s.ScalingPolicyUpdate.Validate(); err != nil {
			invalidParams.AddNested("ScalingPolicyUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the properties of a target tracking scaling policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AutoScalingTargetTrackingScalingPolicyConfigurationDescription
type AutoScalingTargetTrackingScalingPolicyConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether scale in by the target tracking policy is disabled. If
	// the value is true, scale in is disabled and the target tracking policy won't
	// remove capacity from the scalable resource. Otherwise, scale in is enabled
	// and the target tracking policy can remove capacity from the scalable resource.
	// The default value is false.
	DisableScaleIn *bool `type:"boolean"`

	// The amount of time, in seconds, after a scale in activity completes before
	// another scale in activity can start. The cooldown period is used to block
	// subsequent scale in requests until it has expired. You should scale in conservatively
	// to protect your application's availability. However, if another alarm triggers
	// a scale out policy during the cooldown period after a scale-in, application
	// autoscaling scales out your scalable target immediately.
	ScaleInCooldown *int64 `type:"integer"`

	// The amount of time, in seconds, after a scale out activity completes before
	// another scale out activity can start. While the cooldown period is in effect,
	// the capacity that has been added by the previous scale out event that initiated
	// the cooldown is calculated as part of the desired capacity for the next scale
	// out. You should continuously (but not excessively) scale out.
	ScaleOutCooldown *int64 `type:"integer"`

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s AutoScalingTargetTrackingScalingPolicyConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the settings of a target tracking scaling policy that will be
// modified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AutoScalingTargetTrackingScalingPolicyConfigurationUpdate
type AutoScalingTargetTrackingScalingPolicyConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Indicates whether scale in by the target tracking policy is disabled. If
	// the value is true, scale in is disabled and the target tracking policy won't
	// remove capacity from the scalable resource. Otherwise, scale in is enabled
	// and the target tracking policy can remove capacity from the scalable resource.
	// The default value is false.
	DisableScaleIn *bool `type:"boolean"`

	// The amount of time, in seconds, after a scale in activity completes before
	// another scale in activity can start. The cooldown period is used to block
	// subsequent scale in requests until it has expired. You should scale in conservatively
	// to protect your application's availability. However, if another alarm triggers
	// a scale out policy during the cooldown period after a scale-in, application
	// autoscaling scales out your scalable target immediately.
	ScaleInCooldown *int64 `type:"integer"`

	// The amount of time, in seconds, after a scale out activity completes before
	// another scale out activity can start. While the cooldown period is in effect,
	// the capacity that has been added by the previous scale out event that initiated
	// the cooldown is calculated as part of the desired capacity for the next scale
	// out. You should continuously (but not excessively) scale out.
	ScaleOutCooldown *int64 `type:"integer"`

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoScalingTargetTrackingScalingPolicyConfigurationUpdate"}

	if s.TargetValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the description of the backup created for the table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BackupDescription
type BackupDescription struct {
	_ struct{} `type:"structure"`

	// Contains the details of the backup created for the table.
	BackupDetails *BackupDetails `type:"structure"`

	// Contains the details of the table when the backup was created.
	SourceTableDetails *SourceTableDetails `type:"structure"`

	// Contains the details of the features enabled on the table when the backup
	// was created. For example, LSIs, GSIs, streams, TTL.
	SourceTableFeatureDetails *SourceTableFeatureDetails `type:"structure"`
}

// String returns the string representation
func (s BackupDescription) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of the backup created for the table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BackupDetails
type BackupDetails struct {
	_ struct{} `type:"structure"`

	// ARN associated with the backup.
	//
	// BackupArn is a required field
	BackupArn *string `min:"37" type:"string" required:"true"`

	// Time at which the backup was created. This is the request time of the backup.
	//
	// BackupCreationDateTime is a required field
	BackupCreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Time at which the automatic on-demand backup created by DynamoDB will expire.
	// This SYSTEM on-demand backup expires automatically 35 days after its creation.
	BackupExpiryDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Name of the requested backup.
	//
	// BackupName is a required field
	BackupName *string `min:"3" type:"string" required:"true"`

	// Size of the backup in bytes.
	BackupSizeBytes *int64 `type:"long"`

	// Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
	//
	// BackupStatus is a required field
	BackupStatus BackupStatus `type:"string" required:"true" enum:"true"`

	// BackupType:
	//
	//    * USER - You create and manage these using the on-demand backup feature.
	//
	//    * SYSTEM - If you delete a table with point-in-time recovery enabled,
	//    a SYSTEM backup is automatically created and is retained for 35 days (at
	//    no additional cost). System backups allow you to restore the deleted table
	//    to the state it was in just before the point of deletion.
	//
	//    * AWS_BACKUP - On-demand backup created by you from AWS Backup service.
	//
	// BackupType is a required field
	BackupType BackupType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s BackupDetails) String() string {
	return awsutil.Prettify(s)
}

// Contains details for the backup.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BackupSummary
type BackupSummary struct {
	_ struct{} `type:"structure"`

	// ARN associated with the backup.
	BackupArn *string `min:"37" type:"string"`

	// Time at which the backup was created.
	BackupCreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Time at which the automatic on-demand backup created by DynamoDB will expire.
	// This SYSTEM on-demand backup expires automatically 35 days after its creation.
	BackupExpiryDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Name of the specified backup.
	BackupName *string `min:"3" type:"string"`

	// Size of the backup in bytes.
	BackupSizeBytes *int64 `type:"long"`

	// Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
	BackupStatus BackupStatus `type:"string" enum:"true"`

	// BackupType:
	//
	//    * USER - You create and manage these using the on-demand backup feature.
	//
	//    * SYSTEM - If you delete a table with point-in-time recovery enabled,
	//    a SYSTEM backup is automatically created and is retained for 35 days (at
	//    no additional cost). System backups allow you to restore the deleted table
	//    to the state it was in just before the point of deletion.
	//
	//    * AWS_BACKUP - On-demand backup created by you from AWS Backup service.
	BackupType BackupType `type:"string" enum:"true"`

	// ARN associated with the table.
	TableArn *string `type:"string"`

	// Unique identifier for the table.
	TableId *string `type:"string"`

	// Name of the table.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s BackupSummary) String() string {
	return awsutil.Prettify(s)
}

// Contains the details for the read/write capacity mode.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BillingModeSummary
type BillingModeSummary struct {
	_ struct{} `type:"structure"`

	// Controls how you are charged for read and write throughput and how you manage
	// capacity. This setting can be changed later.
	//
	//    * PROVISIONED - Sets the read/write capacity mode to PROVISIONED. We recommend
	//    using PROVISIONED for predictable workloads.
	//
	//    * PAY_PER_REQUEST - Sets the read/write capacity mode to PAY_PER_REQUEST.
	//    We recommend using PAY_PER_REQUEST for unpredictable workloads.
	BillingMode BillingMode `type:"string" enum:"true"`

	// Represents the time when PAY_PER_REQUEST was last set as the read/write capacity
	// mode.
	LastUpdateToPayPerRequestDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s BillingModeSummary) String() string {
	return awsutil.Prettify(s)
}

// An ordered list of errors for each item in the request which caused the transaction
// to get cancelled. The values of the list are ordered according to the ordering
// of the TransactWriteItems request parameter. If no error occurred for the
// associated item an error with a Null code and Null message will be present.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CancellationReason
type CancellationReason struct {
	_ struct{} `type:"structure"`

	// Status code for the result of the cancelled transaction.
	Code *string `type:"string"`

	// Item in the request which caused the transaction to get cancelled.
	Item map[string]AttributeValue `type:"map"`

	// Cancellation reason message description.
	Message *string `type:"string"`
}

// String returns the string representation
func (s CancellationReason) String() string {
	return awsutil.Prettify(s)
}

// Represents the amount of provisioned throughput capacity consumed on a table
// or an index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Capacity
type Capacity struct {
	_ struct{} `type:"structure"`

	// The total number of capacity units consumed on a table or an index.
	CapacityUnits *float64 `type:"double"`

	// The total number of read capacity units consumed on a table or an index.
	ReadCapacityUnits *float64 `type:"double"`

	// The total number of write capacity units consumed on a table or an index.
	WriteCapacityUnits *float64 `type:"double"`
}

// String returns the string representation
func (s Capacity) String() string {
	return awsutil.Prettify(s)
}

// Represents the selection criteria for a Query or Scan operation:
//
//    * For a Query operation, Condition is used for specifying the KeyConditions
//    to use when querying a table or an index. For KeyConditions, only the
//    following comparison operators are supported: EQ | LE | LT | GE | GT |
//    BEGINS_WITH | BETWEEN Condition is also used in a QueryFilter, which evaluates
//    the query results and returns only the desired values.
//
//    * For a Scan operation, Condition is used in a ScanFilter, which evaluates
//    the scan results and returns only the desired values.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Condition
type Condition struct {
	_ struct{} `type:"structure"`

	// One or more values to evaluate against the supplied attribute. The number
	// of values in the list depends on the ComparisonOperator being used.
	//
	// For type Number, value comparisons are numeric.
	//
	// String value comparisons for greater than, equals, or less than are based
	// on ASCII character code values. For example, a is greater than A, and a is
	// greater than B. For a list of code values, see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	//
	// For Binary, DynamoDB treats each byte of the binary data as unsigned when
	// it compares binary values.
	AttributeValueList []AttributeValue `type:"list"`

	// A comparator for evaluating attributes. For example, equals, greater than,
	// less than, etc.
	//
	// The following comparison operators are available:
	//
	// EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS |
	// BEGINS_WITH | IN | BETWEEN
	//
	// The following are descriptions of each comparison operator.
	//
	//    * EQ : Equal. EQ is supported for all data types, including lists and
	//    maps. AttributeValueList can contain only one AttributeValue element of
	//    type String, Number, Binary, String Set, Number Set, or Binary Set. If
	//    an item contains an AttributeValue element of a different type than the
	//    one provided in the request, the value does not match. For example, {"S":"6"}
	//    does not equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2",
	//    "1"]}.
	//
	//    * NE : Not equal. NE is supported for all data types, including lists
	//    and maps. AttributeValueList can contain only one AttributeValue of type
	//    String, Number, Binary, String Set, Number Set, or Binary Set. If an item
	//    contains an AttributeValue of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	//    * LE : Less than or equal. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If an item
	//    contains an AttributeValue element of a different type than the one provided
	//    in the request, the value does not match. For example, {"S":"6"} does
	//    not equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * LT : Less than. AttributeValueList can contain only one AttributeValue
	//    of type String, Number, or Binary (not a set type). If an item contains
	//    an AttributeValue element of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * GE : Greater than or equal. AttributeValueList can contain only one
	//    AttributeValue element of type String, Number, or Binary (not a set type).
	//    If an item contains an AttributeValue element of a different type than
	//    the one provided in the request, the value does not match. For example,
	//    {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not compare to
	//    {"NS":["6", "2", "1"]}.
	//
	//    * GT : Greater than. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If an item
	//    contains an AttributeValue element of a different type than the one provided
	//    in the request, the value does not match. For example, {"S":"6"} does
	//    not equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * NOT_NULL : The attribute exists. NOT_NULL is supported for all data
	//    types, including lists and maps. This operator tests for the existence
	//    of an attribute, not its data type. If the data type of attribute "a"
	//    is null, and you evaluate it using NOT_NULL, the result is a Boolean true.
	//    This result is because the attribute "a" exists; its data type is not
	//    relevant to the NOT_NULL comparison operator.
	//
	//    * NULL : The attribute does not exist. NULL is supported for all data
	//    types, including lists and maps. This operator tests for the nonexistence
	//    of an attribute, not its data type. If the data type of attribute "a"
	//    is null, and you evaluate it using NULL, the result is a Boolean false.
	//    This is because the attribute "a" exists; its data type is not relevant
	//    to the NULL comparison operator.
	//
	//    * CONTAINS : Checks for a subsequence, or value in a set. AttributeValueList
	//    can contain only one AttributeValue element of type String, Number, or
	//    Binary (not a set type). If the target attribute of the comparison is
	//    of type String, then the operator checks for a substring match. If the
	//    target attribute of the comparison is of type Binary, then the operator
	//    looks for a subsequence of the target that matches the input. If the target
	//    attribute of the comparison is a set ("SS", "NS", or "BS"), then the operator
	//    evaluates to true if it finds an exact match with any member of the set.
	//    CONTAINS is supported for lists: When evaluating "a CONTAINS b", "a" can
	//    be a list; however, "b" cannot be a set, a map, or a list.
	//
	//    * NOT_CONTAINS : Checks for absence of a subsequence, or absence of a
	//    value in a set. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If the target
	//    attribute of the comparison is a String, then the operator checks for
	//    the absence of a substring match. If the target attribute of the comparison
	//    is Binary, then the operator checks for the absence of a subsequence of
	//    the target that matches the input. If the target attribute of the comparison
	//    is a set ("SS", "NS", or "BS"), then the operator evaluates to true if
	//    it does not find an exact match with any member of the set. NOT_CONTAINS
	//    is supported for lists: When evaluating "a NOT CONTAINS b", "a" can be
	//    a list; however, "b" cannot be a set, a map, or a list.
	//
	//    * BEGINS_WITH : Checks for a prefix. AttributeValueList can contain only
	//    one AttributeValue of type String or Binary (not a Number or a set type).
	//    The target attribute of the comparison must be of type String or Binary
	//    (not a Number or a set type).
	//
	//    * IN : Checks for matching elements in a list. AttributeValueList can
	//    contain one or more AttributeValue elements of type String, Number, or
	//    Binary. These attributes are compared against an existing attribute of
	//    an item. If any elements of the input are equal to the item attribute,
	//    the expression evaluates to true.
	//
	//    * BETWEEN : Greater than or equal to the first value, and less than or
	//    equal to the second value. AttributeValueList must contain two AttributeValue
	//    elements of the same type, either String, Number, or Binary (not a set
	//    type). A target attribute matches if the target value is greater than,
	//    or equal to, the first element and less than, or equal to, the second
	//    element. If an item contains an AttributeValue element of a different
	//    type than the one provided in the request, the value does not match. For
	//    example, {"S":"6"} does not compare to {"N":"6"}. Also, {"N":"6"} does
	//    not compare to {"NS":["6", "2", "1"]}
	//
	// For usage examples of AttributeValueList and ComparisonOperator, see Legacy
	// Conditional Parameters (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ComparisonOperator is a required field
	ComparisonOperator ComparisonOperator `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Condition"}
	if len(s.ComparisonOperator) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ComparisonOperator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a request to perform a check that an item exists or to check the
// condition of specific attributes of the item..
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ConditionCheck
type ConditionCheck struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional update to succeed.
	//
	// ConditionExpression is a required field
	ConditionExpression *string `type:"string" required:"true"`

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]string `type:"map"`

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]AttributeValue `type:"map"`

	// The primary key of the item to be checked. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// Key is a required field
	Key map[string]AttributeValue `type:"map" required:"true"`

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// ConditionCheck condition fails. For ReturnValuesOnConditionCheckFailure,
	// the valid values are: NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure ReturnValuesOnConditionCheckFailure `type:"string" enum:"true"`

	// Name of the table for the check item request.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s ConditionCheck) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionCheck) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConditionCheck"}

	if s.ConditionExpression == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConditionExpression"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The capacity units consumed by an operation. The data returned includes the
// total provisioned throughput consumed, along with statistics for the table
// and any indexes involved in the operation. ConsumedCapacity is only returned
// if the request asked for it. For more information, see Provisioned Throughput
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
// in the Amazon DynamoDB Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ConsumedCapacity
type ConsumedCapacity struct {
	_ struct{} `type:"structure"`

	// The total number of capacity units consumed by the operation.
	CapacityUnits *float64 `type:"double"`

	// The amount of throughput consumed on each global index affected by the operation.
	GlobalSecondaryIndexes map[string]Capacity `type:"map"`

	// The amount of throughput consumed on each local index affected by the operation.
	LocalSecondaryIndexes map[string]Capacity `type:"map"`

	// The total number of read capacity units consumed by the operation.
	ReadCapacityUnits *float64 `type:"double"`

	// The amount of throughput consumed on the table affected by the operation.
	Table *Capacity `type:"structure"`

	// The name of the table that was affected by the operation.
	TableName *string `min:"3" type:"string"`

	// The total number of write capacity units consumed by the operation.
	WriteCapacityUnits *float64 `type:"double"`
}

// String returns the string representation
func (s ConsumedCapacity) String() string {
	return awsutil.Prettify(s)
}

// Represents the continuous backups and point in time recovery settings on
// the table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ContinuousBackupsDescription
type ContinuousBackupsDescription struct {
	_ struct{} `type:"structure"`

	// ContinuousBackupsStatus can be one of the following states: ENABLED, DISABLED
	//
	// ContinuousBackupsStatus is a required field
	ContinuousBackupsStatus ContinuousBackupsStatus `type:"string" required:"true" enum:"true"`

	// The description of the point in time recovery settings applied to the table.
	PointInTimeRecoveryDescription *PointInTimeRecoveryDescription `type:"structure"`
}

// String returns the string representation
func (s ContinuousBackupsDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents a new global secondary index to be added to an existing table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalSecondaryIndexAction
type CreateGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be created.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The key schema for the global secondary index.
	//
	// KeySchema is a required field
	KeySchema []KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into an
	// index. These are in addition to the primary key attributes and index key
	// attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`
}

// String returns the string representation
func (s CreateGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlobalSecondaryIndexAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGlobalSecondaryIndexAction"}

	if s.IndexName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}

	if s.KeySchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeySchema", 1))
	}

	if s.Projection == nil {
		invalidParams.Add(aws.NewErrParamRequired("Projection"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(aws.ErrInvalidParams))
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a replica to be added.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateReplicaAction
type CreateReplicaAction struct {
	_ struct{} `type:"structure"`

	// The region of the replica to be added.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReplicaAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicaAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateReplicaAction"}

	if s.RegionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a request to perform a DeleteItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Delete
type Delete struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional delete to succeed.
	ConditionExpression *string `type:"string"`

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]string `type:"map"`

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]AttributeValue `type:"map"`

	// The primary key of the item to be deleted. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// Key is a required field
	Key map[string]AttributeValue `type:"map" required:"true"`

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// Delete condition fails. For ReturnValuesOnConditionCheckFailure, the valid
	// values are: NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure ReturnValuesOnConditionCheckFailure `type:"string" enum:"true"`

	// Name of the table in which the item to be deleted resides.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Delete"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a global secondary index to be deleted from an existing table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteGlobalSecondaryIndexAction
type DeleteGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be deleted.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGlobalSecondaryIndexAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteGlobalSecondaryIndexAction"}

	if s.IndexName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a replica to be removed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteReplicaAction
type DeleteReplicaAction struct {
	_ struct{} `type:"structure"`

	// The region of the replica to be removed.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicaAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicaAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteReplicaAction"}

	if s.RegionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a request to perform a DeleteItem operation on an item.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteRequest
type DeleteRequest struct {
	_ struct{} `type:"structure"`

	// A map of attribute name to attribute values, representing the primary key
	// of the item to delete. All of the table's primary key attributes must be
	// specified, and their data types must match those of the table's key schema.
	//
	// Key is a required field
	Key map[string]AttributeValue `type:"map" required:"true"`
}

// String returns the string representation
func (s DeleteRequest) String() string {
	return awsutil.Prettify(s)
}

// An endpoint information details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Endpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// IP address of the endpoint.
	//
	// Address is a required field
	Address *string `type:"string" required:"true"`

	// Endpoint cache time to live (TTL) value.
	//
	// CachePeriodInMinutes is a required field
	CachePeriodInMinutes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// Represents a condition to be compared with an attribute value. This condition
// can be used with DeleteItem, PutItem or UpdateItem operations; if the comparison
// evaluates to true, the operation succeeds; if not, the operation fails. You
// can use ExpectedAttributeValue in one of two different ways:
//
//    * Use AttributeValueList to specify one or more values to compare against
//    an attribute. Use ComparisonOperator to specify how you want to perform
//    the comparison. If the comparison evaluates to true, then the conditional
//    operation succeeds.
//
//    * Use Value to specify a value that DynamoDB will compare against an attribute.
//    If the values match, then ExpectedAttributeValue evaluates to true and
//    the conditional operation succeeds. Optionally, you can also set Exists
//    to false, indicating that you do not expect to find the attribute value
//    in the table. In this case, the conditional operation succeeds only if
//    the comparison evaluates to false.
//
// Value and Exists are incompatible with AttributeValueList and ComparisonOperator.
// Note that if you use both sets of parameters at once, DynamoDB will return
// a ValidationException exception.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExpectedAttributeValue
type ExpectedAttributeValue struct {
	_ struct{} `type:"structure"`

	// One or more values to evaluate against the supplied attribute. The number
	// of values in the list depends on the ComparisonOperator being used.
	//
	// For type Number, value comparisons are numeric.
	//
	// String value comparisons for greater than, equals, or less than are based
	// on ASCII character code values. For example, a is greater than A, and a is
	// greater than B. For a list of code values, see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	//
	// For Binary, DynamoDB treats each byte of the binary data as unsigned when
	// it compares binary values.
	//
	// For information on specifying data types in JSON, see JSON Data Format (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributeValueList []AttributeValue `type:"list"`

	// A comparator for evaluating attributes in the AttributeValueList. For example,
	// equals, greater than, less than, etc.
	//
	// The following comparison operators are available:
	//
	// EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS |
	// BEGINS_WITH | IN | BETWEEN
	//
	// The following are descriptions of each comparison operator.
	//
	//    * EQ : Equal. EQ is supported for all data types, including lists and
	//    maps. AttributeValueList can contain only one AttributeValue element of
	//    type String, Number, Binary, String Set, Number Set, or Binary Set. If
	//    an item contains an AttributeValue element of a different type than the
	//    one provided in the request, the value does not match. For example, {"S":"6"}
	//    does not equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2",
	//    "1"]}.
	//
	//    * NE : Not equal. NE is supported for all data types, including lists
	//    and maps. AttributeValueList can contain only one AttributeValue of type
	//    String, Number, Binary, String Set, Number Set, or Binary Set. If an item
	//    contains an AttributeValue of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	//    * LE : Less than or equal. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If an item
	//    contains an AttributeValue element of a different type than the one provided
	//    in the request, the value does not match. For example, {"S":"6"} does
	//    not equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * LT : Less than. AttributeValueList can contain only one AttributeValue
	//    of type String, Number, or Binary (not a set type). If an item contains
	//    an AttributeValue element of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * GE : Greater than or equal. AttributeValueList can contain only one
	//    AttributeValue element of type String, Number, or Binary (not a set type).
	//    If an item contains an AttributeValue element of a different type than
	//    the one provided in the request, the value does not match. For example,
	//    {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"} does not compare to
	//    {"NS":["6", "2", "1"]}.
	//
	//    * GT : Greater than. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If an item
	//    contains an AttributeValue element of a different type than the one provided
	//    in the request, the value does not match. For example, {"S":"6"} does
	//    not equal {"N":"6"}. Also, {"N":"6"} does not compare to {"NS":["6", "2",
	//    "1"]}.
	//
	//    * NOT_NULL : The attribute exists. NOT_NULL is supported for all data
	//    types, including lists and maps. This operator tests for the existence
	//    of an attribute, not its data type. If the data type of attribute "a"
	//    is null, and you evaluate it using NOT_NULL, the result is a Boolean true.
	//    This result is because the attribute "a" exists; its data type is not
	//    relevant to the NOT_NULL comparison operator.
	//
	//    * NULL : The attribute does not exist. NULL is supported for all data
	//    types, including lists and maps. This operator tests for the nonexistence
	//    of an attribute, not its data type. If the data type of attribute "a"
	//    is null, and you evaluate it using NULL, the result is a Boolean false.
	//    This is because the attribute "a" exists; its data type is not relevant
	//    to the NULL comparison operator.
	//
	//    * CONTAINS : Checks for a subsequence, or value in a set. AttributeValueList
	//    can contain only one AttributeValue element of type String, Number, or
	//    Binary (not a set type). If the target attribute of the comparison is
	//    of type String, then the operator checks for a substring match. If the
	//    target attribute of the comparison is of type Binary, then the operator
	//    looks for a subsequence of the target that matches the input. If the target
	//    attribute of the comparison is a set ("SS", "NS", or "BS"), then the operator
	//    evaluates to true if it finds an exact match with any member of the set.
	//    CONTAINS is supported for lists: When evaluating "a CONTAINS b", "a" can
	//    be a list; however, "b" cannot be a set, a map, or a list.
	//
	//    * NOT_CONTAINS : Checks for absence of a subsequence, or absence of a
	//    value in a set. AttributeValueList can contain only one AttributeValue
	//    element of type String, Number, or Binary (not a set type). If the target
	//    attribute of the comparison is a String, then the operator checks for
	//    the absence of a substring match. If the target attribute of the comparison
	//    is Binary, then the operator checks for the absence of a subsequence of
	//    the target that matches the input. If the target attribute of the comparison
	//    is a set ("SS", "NS", or "BS"), then the operator evaluates to true if
	//    it does not find an exact match with any member of the set. NOT_CONTAINS
	//    is supported for lists: When evaluating "a NOT CONTAINS b", "a" can be
	//    a list; however, "b" cannot be a set, a map, or a list.
	//
	//    * BEGINS_WITH : Checks for a prefix. AttributeValueList can contain only
	//    one AttributeValue of type String or Binary (not a Number or a set type).
	//    The target attribute of the comparison must be of type String or Binary
	//    (not a Number or a set type).
	//
	//    * IN : Checks for matching elements in a list. AttributeValueList can
	//    contain one or more AttributeValue elements of type String, Number, or
	//    Binary. These attributes are compared against an existing attribute of
	//    an item. If any elements of the input are equal to the item attribute,
	//    the expression evaluates to true.
	//
	//    * BETWEEN : Greater than or equal to the first value, and less than or
	//    equal to the second value. AttributeValueList must contain two AttributeValue
	//    elements of the same type, either String, Number, or Binary (not a set
	//    type). A target attribute matches if the target value is greater than,
	//    or equal to, the first element and less than, or equal to, the second
	//    element. If an item contains an AttributeValue element of a different
	//    type than the one provided in the request, the value does not match. For
	//    example, {"S":"6"} does not compare to {"N":"6"}. Also, {"N":"6"} does
	//    not compare to {"NS":["6", "2", "1"]}
	ComparisonOperator ComparisonOperator `type:"string" enum:"true"`

	// Causes DynamoDB to evaluate the value before attempting a conditional operation:
	//
	//    * If Exists is true, DynamoDB will check to see if that attribute value
	//    already exists in the table. If it is found, then the operation succeeds.
	//    If it is not found, the operation fails with a ConditionCheckFailedException.
	//
	//    * If Exists is false, DynamoDB assumes that the attribute value does not
	//    exist in the table. If in fact the value does not exist, then the assumption
	//    is valid and the operation succeeds. If the value is found, despite the
	//    assumption that it does not exist, the operation fails with a ConditionCheckFailedException.
	//
	// The default setting for Exists is true. If you supply a Value all by itself,
	// DynamoDB assumes the attribute exists: You don't have to set Exists to true,
	// because it is implied.
	//
	// DynamoDB returns a ValidationException if:
	//
	//    * Exists is true but there is no Value to check. (You expect a value to
	//    exist, but don't specify what that value is.)
	//
	//    * Exists is false but you also provide a Value. (You cannot expect an
	//    attribute to have a value, while also expecting it not to exist.)
	Exists *bool `type:"boolean"`

	// Represents the data for the expected attribute.
	//
	// Each attribute value is described as a name-value pair. The name is the data
	// type, and the value is the data itself.
	//
	// For more information, see Data Types (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
	// in the Amazon DynamoDB Developer Guide.
	Value *AttributeValue `type:"structure"`
}

// String returns the string representation
func (s ExpectedAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Specifies an item and related attribute values to retrieve in a TransactGetItem
// object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Get
type Get struct {
	_ struct{} `type:"structure"`

	// One or more substitution tokens for attribute names in the ProjectionExpression
	// parameter.
	ExpressionAttributeNames map[string]string `type:"map"`

	// A map of attribute names to AttributeValue objects that specifies the primary
	// key of the item to retrieve.
	//
	// Key is a required field
	Key map[string]AttributeValue `type:"map" required:"true"`

	// A string that identifies one or more attributes of the specified item to
	// retrieve from the table. The attributes in the expression must be separated
	// by commas. If no attribute names are specified, then all attributes of the
	// specified item are returned. If any of the requested attributes are not found,
	// they do not appear in the result.
	ProjectionExpression *string `type:"string"`

	// The name of the table from which to retrieve the specified item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s Get) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Get) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Get"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the properties of a global secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalSecondaryIndex
type GlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The complete key schema for a global secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeySchema is a required field
	KeySchema []KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSecondaryIndex) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlobalSecondaryIndex"}

	if s.IndexName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}

	if s.KeySchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeySchema", 1))
	}

	if s.Projection == nil {
		invalidParams.Add(aws.NewErrParamRequired("Projection"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(aws.ErrInvalidParams))
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the properties of a global secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalSecondaryIndexDescription
type GlobalSecondaryIndexDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether the index is currently backfilling. Backfilling is the
	// process of reading items from the table and determining whether they can
	// be added to the index. (Not all items will qualify: For example, a partition
	// key cannot have any duplicate values.) If an item can be added to the index,
	// DynamoDB will do so. After all items have been processed, the backfilling
	// operation is complete and Backfilling is false.
	//
	// For indexes that were created during a CreateTable operation, the Backfilling
	// attribute does not appear in the DescribeTable output.
	Backfilling *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) that uniquely identifies the index.
	IndexArn *string `type:"string"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// The total size of the specified index, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	IndexSizeBytes *int64 `type:"long"`

	// The current state of the global secondary index:
	//
	//    * CREATING - The index is being created.
	//
	//    * UPDATING - The index is being updated.
	//
	//    * DELETING - The index is being deleted.
	//
	//    * ACTIVE - The index is ready for use.
	IndexStatus IndexStatus `type:"string" enum:"true"`

	// The number of items in the specified index. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The complete key schema for a global secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughputDescription `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the properties of a global secondary index for the table when
// the backup was created.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalSecondaryIndexInfo
type GlobalSecondaryIndexInfo struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// The complete key schema for a global secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexInfo) String() string {
	return awsutil.Prettify(s)
}

// Represents one of the following:
//
//    * A new global secondary index to be added to an existing table.
//
//    * New provisioned throughput parameters for an existing global secondary
//    index.
//
//    * An existing global secondary index to be removed from an existing table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalSecondaryIndexUpdate
type GlobalSecondaryIndexUpdate struct {
	_ struct{} `type:"structure"`

	// The parameters required for creating a global secondary index on an existing
	// table:
	//
	//    * IndexName
	//
	//    * KeySchema
	//
	//    * AttributeDefinitions
	//
	//    * Projection
	//
	//    * ProvisionedThroughput
	Create *CreateGlobalSecondaryIndexAction `type:"structure"`

	// The name of an existing global secondary index to be removed.
	Delete *DeleteGlobalSecondaryIndexAction `type:"structure"`

	// The name of an existing global secondary index, along with new provisioned
	// throughput settings to be applied to that index.
	Update *UpdateGlobalSecondaryIndexAction `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSecondaryIndexUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlobalSecondaryIndexUpdate"}
	if s.Create != nil {
		if err := s.Create.Validate(); err != nil {
			invalidParams.AddNested("Create", err.(aws.ErrInvalidParams))
		}
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(aws.ErrInvalidParams))
		}
	}
	if s.Update != nil {
		if err := s.Update.Validate(); err != nil {
			invalidParams.AddNested("Update", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the properties of a global table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalTable
type GlobalTable struct {
	_ struct{} `type:"structure"`

	// The global table name.
	GlobalTableName *string `min:"3" type:"string"`

	// The regions where the global table has replicas.
	ReplicationGroup []Replica `type:"list"`
}

// String returns the string representation
func (s GlobalTable) String() string {
	return awsutil.Prettify(s)
}

// Contains details about the global table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalTableDescription
type GlobalTableDescription struct {
	_ struct{} `type:"structure"`

	// The creation time of the global table.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The unique identifier of the global table.
	GlobalTableArn *string `type:"string"`

	// The global table name.
	GlobalTableName *string `min:"3" type:"string"`

	// The current state of the global table:
	//
	//    * CREATING - The global table is being created.
	//
	//    * UPDATING - The global table is being updated.
	//
	//    * DELETING - The global table is being deleted.
	//
	//    * ACTIVE - The global table is ready for use.
	GlobalTableStatus GlobalTableStatus `type:"string" enum:"true"`

	// The regions where the global table has replicas.
	ReplicationGroup []ReplicaDescription `type:"list"`
}

// String returns the string representation
func (s GlobalTableDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the settings of a global secondary index for a global table that
// will be modified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalTableGlobalSecondaryIndexSettingsUpdate
type GlobalTableGlobalSecondaryIndexSettingsUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// AutoScaling settings for managing a global secondary index's write capacity
	// units.
	ProvisionedWriteCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate `type:"structure"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	ProvisionedWriteCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s GlobalTableGlobalSecondaryIndexSettingsUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalTableGlobalSecondaryIndexSettingsUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlobalTableGlobalSecondaryIndexSettingsUpdate"}

	if s.IndexName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedWriteCapacityUnits != nil && *s.ProvisionedWriteCapacityUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ProvisionedWriteCapacityUnits", 1))
	}
	if s.ProvisionedWriteCapacityAutoScalingSettingsUpdate != nil {
		if err := s.ProvisionedWriteCapacityAutoScalingSettingsUpdate.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedWriteCapacityAutoScalingSettingsUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about item collections, if any, that were affected by the operation.
// ItemCollectionMetrics is only returned if the request asked for it. If the
// table does not have any local secondary indexes, this information is not
// returned in the response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ItemCollectionMetrics
type ItemCollectionMetrics struct {
	_ struct{} `type:"structure"`

	// The partition key value of the item collection. This value is the same as
	// the partition key value of the item.
	ItemCollectionKey map[string]AttributeValue `type:"map"`

	// An estimate of item collection size, in gigabytes. This value is a two-element
	// array containing a lower bound and an upper bound for the estimate. The estimate
	// includes the size of all the items in the table, plus the size of all attributes
	// projected into all of the local secondary indexes on that table. Use this
	// estimate to measure whether a local secondary index is approaching its size
	// limit.
	//
	// The estimate is subject to change over time; therefore, do not rely on the
	// precision or accuracy of the estimate.
	SizeEstimateRangeGB []float64 `type:"list"`
}

// String returns the string representation
func (s ItemCollectionMetrics) String() string {
	return awsutil.Prettify(s)
}

// Details for the requested item.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ItemResponse
type ItemResponse struct {
	_ struct{} `type:"structure"`

	// Map of attribute data consisting of the data type and attribute value.
	Item map[string]AttributeValue `type:"map"`
}

// String returns the string representation
func (s ItemResponse) String() string {
	return awsutil.Prettify(s)
}

// Represents a single element of a key schema. A key schema specifies the attributes
// that make up the primary key of a table, or the key attributes of an index.
//
// A KeySchemaElement represents exactly one attribute of the primary key. For
// example, a simple primary key would be represented by one KeySchemaElement
// (for the partition key). A composite primary key would require one KeySchemaElement
// for the partition key, and another KeySchemaElement for the sort key.
//
// A KeySchemaElement must be a scalar, top-level attribute (not a nested attribute).
// The data type must be one of String, Number, or Binary. The attribute cannot
// be nested within a List or a Map.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/KeySchemaElement
type KeySchemaElement struct {
	_ struct{} `type:"structure"`

	// The name of a key attribute.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The role that this key attribute will assume:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeyType is a required field
	KeyType KeyType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s KeySchemaElement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeySchemaElement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KeySchemaElement"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}
	if len(s.KeyType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("KeyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a set of primary keys and, for each key, the attributes to retrieve
// from the table.
//
// For each primary key, you must provide all of the key attributes. For example,
// with a simple primary key, you only need to provide the partition key. For
// a composite primary key, you must provide both the partition key and the
// sort key.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/KeysAndAttributes
type KeysAndAttributes struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see Legacy Conditional Parameters (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []string `min:"1" type:"list"`

	// The consistency of a read operation. If set to true, then a strongly consistent
	// read is used; otherwise, an eventually consistent read is used.
	ConsistentRead *bool `type:"boolean"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]string `type:"map"`

	// The primary key attribute values that define the items and the attributes
	// associated with the items.
	//
	// Keys is a required field
	Keys []map[string]AttributeValue `min:"1" type:"list" required:"true"`

	// A string that identifies one or more attributes to retrieve from the table.
	// These attributes can include scalars, sets, or elements of a JSON document.
	// The attributes in the ProjectionExpression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	// If any of the requested attributes are not found, they will not appear in
	// the result.
	//
	// For more information, see Accessing Item Attributes (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`
}

// String returns the string representation
func (s KeysAndAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeysAndAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KeysAndAttributes"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributesToGet", 1))
	}

	if s.Keys == nil {
		invalidParams.Add(aws.NewErrParamRequired("Keys"))
	}
	if s.Keys != nil && len(s.Keys) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Keys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the properties of a local secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/LocalSecondaryIndex
type LocalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the local secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The complete key schema for the local secondary index, consisting of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeySchema is a required field
	KeySchema []KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into the
	// local secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`
}

// String returns the string representation
func (s LocalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LocalSecondaryIndex) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LocalSecondaryIndex"}

	if s.IndexName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}

	if s.KeySchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeySchema", 1))
	}

	if s.Projection == nil {
		invalidParams.Add(aws.NewErrParamRequired("Projection"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the properties of a local secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/LocalSecondaryIndexDescription
type LocalSecondaryIndexDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the index.
	IndexArn *string `type:"string"`

	// Represents the name of the local secondary index.
	IndexName *string `min:"3" type:"string"`

	// The total size of the specified index, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	IndexSizeBytes *int64 `type:"long"`

	// The number of items in the specified index. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The complete key schema for the local secondary index, consisting of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`
}

// String returns the string representation
func (s LocalSecondaryIndexDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the properties of a local secondary index for the table when the
// backup was created.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/LocalSecondaryIndexInfo
type LocalSecondaryIndexInfo struct {
	_ struct{} `type:"structure"`

	// Represents the name of the local secondary index.
	IndexName *string `min:"3" type:"string"`

	// The complete key schema for a local secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`
}

// String returns the string representation
func (s LocalSecondaryIndexInfo) String() string {
	return awsutil.Prettify(s)
}

// The description of the point in time settings applied to the table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PointInTimeRecoveryDescription
type PointInTimeRecoveryDescription struct {
	_ struct{} `type:"structure"`

	// Specifies the earliest point in time you can restore your table to. It You
	// can restore your table to any point in time during the last 35 days.
	EarliestRestorableDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// LatestRestorableDateTime is typically 5 minutes before the current time.
	LatestRestorableDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The current state of point in time recovery:
	//
	//    * ENABLING - Point in time recovery is being enabled.
	//
	//    * ENABLED - Point in time recovery is enabled.
	//
	//    * DISABLED - Point in time recovery is disabled.
	PointInTimeRecoveryStatus PointInTimeRecoveryStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s PointInTimeRecoveryDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the settings used to enable point in time recovery.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PointInTimeRecoverySpecification
type PointInTimeRecoverySpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether point in time recovery is enabled (true) or disabled (false)
	// on the table.
	//
	// PointInTimeRecoveryEnabled is a required field
	PointInTimeRecoveryEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s PointInTimeRecoverySpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PointInTimeRecoverySpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PointInTimeRecoverySpecification"}

	if s.PointInTimeRecoveryEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("PointInTimeRecoveryEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents attributes that are copied (projected) from the table into an
// index. These are in addition to the primary key attributes and index key
// attributes, which are automatically projected.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Projection
type Projection struct {
	_ struct{} `type:"structure"`

	// Represents the non-key attribute names which will be projected into the index.
	//
	// For local secondary indexes, the total count of NonKeyAttributes summed across
	// all of the local secondary indexes, must not exceed 20. If you project the
	// same attribute into two different indexes, this counts as two distinct attributes
	// when determining the total.
	NonKeyAttributes []string `min:"1" type:"list"`

	// The set of attributes that are projected into the index:
	//
	//    * KEYS_ONLY - Only the index and primary keys are projected into the index.
	//
	//    * INCLUDE - Only the specified table attributes are projected into the
	//    index. The list of projected attributes are in NonKeyAttributes.
	//
	//    * ALL - All of the table attributes are projected into the index.
	ProjectionType ProjectionType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Projection) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Projection) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Projection"}
	if s.NonKeyAttributes != nil && len(s.NonKeyAttributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NonKeyAttributes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the provisioned throughput settings for a specified table or index.
// The settings can be modified using the UpdateTable operation.
//
// For current minimum and maximum provisioned throughput values, see Limits
// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
// in the Amazon DynamoDB Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ProvisionedThroughput
type ProvisionedThroughput struct {
	_ struct{} `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	//
	// If read/write capacity mode is PAY_PER_REQUEST the value is set to 0.
	//
	// ReadCapacityUnits is a required field
	ReadCapacityUnits *int64 `min:"1" type:"long" required:"true"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException. For more information, see Specifying Read and Write
	// Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	//
	// If read/write capacity mode is PAY_PER_REQUEST the value is set to 0.
	//
	// WriteCapacityUnits is a required field
	WriteCapacityUnits *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s ProvisionedThroughput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionedThroughput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProvisionedThroughput"}

	if s.ReadCapacityUnits == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReadCapacityUnits"))
	}
	if s.ReadCapacityUnits != nil && *s.ReadCapacityUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ReadCapacityUnits", 1))
	}

	if s.WriteCapacityUnits == nil {
		invalidParams.Add(aws.NewErrParamRequired("WriteCapacityUnits"))
	}
	if s.WriteCapacityUnits != nil && *s.WriteCapacityUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("WriteCapacityUnits", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the provisioned throughput settings for the table, consisting
// of read and write capacity units, along with data about increases and decreases.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ProvisionedThroughputDescription
type ProvisionedThroughputDescription struct {
	_ struct{} `type:"structure"`

	// The date and time of the last provisioned throughput decrease for this table.
	LastDecreaseDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time of the last provisioned throughput increase for this table.
	LastIncreaseDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The number of provisioned throughput decreases for this table during this
	// UTC calendar day. For current maximums on provisioned throughput decreases,
	// see Limits (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	NumberOfDecreasesToday *int64 `min:"1" type:"long"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. Eventually consistent reads require
	// less effort than strongly consistent reads, so a setting of 50 ReadCapacityUnits
	// per second provides 100 eventually consistent ReadCapacityUnits per second.
	ReadCapacityUnits *int64 `type:"long"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	WriteCapacityUnits *int64 `type:"long"`
}

// String returns the string representation
func (s ProvisionedThroughputDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents a request to perform a PutItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Put
type Put struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional update to succeed.
	ConditionExpression *string `type:"string"`

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]string `type:"map"`

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]AttributeValue `type:"map"`

	// A map of attribute name to attribute values, representing the primary key
	// of the item to be written by PutItem. All of the table's primary key attributes
	// must be specified, and their data types must match those of the table's key
	// schema. If any attributes are present in the item that are part of an index
	// key schema for the table, their types must match the index key schema.
	//
	// Item is a required field
	Item map[string]AttributeValue `type:"map" required:"true"`

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// Put condition fails. For ReturnValuesOnConditionCheckFailure, the valid values
	// are: NONE and ALL_OLD.
	ReturnValuesOnConditionCheckFailure ReturnValuesOnConditionCheckFailure `type:"string" enum:"true"`

	// Name of the table in which to write the item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s Put) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Put) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Put"}

	if s.Item == nil {
		invalidParams.Add(aws.NewErrParamRequired("Item"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a request to perform a PutItem operation on an item.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutRequest
type PutRequest struct {
	_ struct{} `type:"structure"`

	// A map of attribute name to attribute values, representing the primary key
	// of an item to be processed by PutItem. All of the table's primary key attributes
	// must be specified, and their data types must match those of the table's key
	// schema. If any attributes are present in the item which are part of an index
	// key schema for the table, their types must match the index key schema.
	//
	// Item is a required field
	Item map[string]AttributeValue `type:"map" required:"true"`
}

// String returns the string representation
func (s PutRequest) String() string {
	return awsutil.Prettify(s)
}

// Represents the properties of a replica.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Replica
type Replica struct {
	_ struct{} `type:"structure"`

	// The region where the replica needs to be created.
	RegionName *string `type:"string"`
}

// String returns the string representation
func (s Replica) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of the replica.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ReplicaDescription
type ReplicaDescription struct {
	_ struct{} `type:"structure"`

	// The name of the region.
	RegionName *string `type:"string"`
}

// String returns the string representation
func (s ReplicaDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the properties of a global secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ReplicaGlobalSecondaryIndexSettingsDescription
type ReplicaGlobalSecondaryIndexSettingsDescription struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The current status of the global secondary index:
	//
	//    * CREATING - The global secondary index is being created.
	//
	//    * UPDATING - The global secondary index is being updated.
	//
	//    * DELETING - The global secondary index is being deleted.
	//
	//    * ACTIVE - The global secondary index is ready for use.
	IndexStatus IndexStatus `type:"string" enum:"true"`

	// Autoscaling settings for a global secondary index replica's read capacity
	// units.
	ProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ProvisionedReadCapacityUnits *int64 `min:"1" type:"long"`

	// AutoScaling settings for a global secondary index replica's write capacity
	// units.
	ProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	ProvisionedWriteCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ReplicaGlobalSecondaryIndexSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the settings of a global secondary index for a global table that
// will be modified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ReplicaGlobalSecondaryIndexSettingsUpdate
type ReplicaGlobalSecondaryIndexSettingsUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// Autoscaling settings for managing a global secondary index replica's read
	// capacity units.
	ProvisionedReadCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException.
	ProvisionedReadCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ReplicaGlobalSecondaryIndexSettingsUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaGlobalSecondaryIndexSettingsUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicaGlobalSecondaryIndexSettingsUpdate"}

	if s.IndexName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedReadCapacityUnits != nil && *s.ProvisionedReadCapacityUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ProvisionedReadCapacityUnits", 1))
	}
	if s.ProvisionedReadCapacityAutoScalingSettingsUpdate != nil {
		if err := s.ProvisionedReadCapacityAutoScalingSettingsUpdate.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedReadCapacityAutoScalingSettingsUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the properties of a replica.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ReplicaSettingsDescription
type ReplicaSettingsDescription struct {
	_ struct{} `type:"structure"`

	// The region name of the replica.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`

	// The read/write capacity mode of the replica.
	ReplicaBillingModeSummary *BillingModeSummary `type:"structure"`

	// Replica global secondary index settings for the global table.
	ReplicaGlobalSecondaryIndexSettings []ReplicaGlobalSecondaryIndexSettingsDescription `type:"list"`

	// Autoscaling settings for a global table replica's read capacity units.
	ReplicaProvisionedReadCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedReadCapacityUnits *int64 `type:"long"`

	// AutoScaling settings for a global table replica's write capacity units.
	ReplicaProvisionedWriteCapacityAutoScalingSettings *AutoScalingSettingsDescription `type:"structure"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException. For more information, see Specifying Read and Write
	// Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedWriteCapacityUnits *int64 `type:"long"`

	// The current state of the region:
	//
	//    * CREATING - The region is being created.
	//
	//    * UPDATING - The region is being updated.
	//
	//    * DELETING - The region is being deleted.
	//
	//    * ACTIVE - The region is ready for use.
	ReplicaStatus ReplicaStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ReplicaSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the settings for a global table in a region that will be modified.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ReplicaSettingsUpdate
type ReplicaSettingsUpdate struct {
	_ struct{} `type:"structure"`

	// The region of the replica to be added.
	//
	// RegionName is a required field
	RegionName *string `type:"string" required:"true"`

	// Represents the settings of a global secondary index for a global table that
	// will be modified.
	ReplicaGlobalSecondaryIndexSettingsUpdate []ReplicaGlobalSecondaryIndexSettingsUpdate `min:"1" type:"list"`

	// Autoscaling settings for managing a global table replica's read capacity
	// units.
	ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate *AutoScalingSettingsUpdate `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	ReplicaProvisionedReadCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ReplicaSettingsUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaSettingsUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicaSettingsUpdate"}

	if s.RegionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegionName"))
	}
	if s.ReplicaGlobalSecondaryIndexSettingsUpdate != nil && len(s.ReplicaGlobalSecondaryIndexSettingsUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReplicaGlobalSecondaryIndexSettingsUpdate", 1))
	}
	if s.ReplicaProvisionedReadCapacityUnits != nil && *s.ReplicaProvisionedReadCapacityUnits < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ReplicaProvisionedReadCapacityUnits", 1))
	}
	if s.ReplicaGlobalSecondaryIndexSettingsUpdate != nil {
		for i, v := range s.ReplicaGlobalSecondaryIndexSettingsUpdate {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplicaGlobalSecondaryIndexSettingsUpdate", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate != nil {
		if err := s.ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate.Validate(); err != nil {
			invalidParams.AddNested("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents one of the following:
//
//    * A new replica to be added to an existing global table.
//
//    * New parameters for an existing replica.
//
//    * An existing replica to be removed from an existing global table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ReplicaUpdate
type ReplicaUpdate struct {
	_ struct{} `type:"structure"`

	// The parameters required for creating a replica on an existing global table.
	Create *CreateReplicaAction `type:"structure"`

	// The name of the existing replica to be removed.
	Delete *DeleteReplicaAction `type:"structure"`
}

// String returns the string representation
func (s ReplicaUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicaUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicaUpdate"}
	if s.Create != nil {
		if err := s.Create.Validate(); err != nil {
			invalidParams.AddNested("Create", err.(aws.ErrInvalidParams))
		}
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains details for the restore.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreSummary
type RestoreSummary struct {
	_ struct{} `type:"structure"`

	// Point in time or source backup time.
	//
	// RestoreDateTime is a required field
	RestoreDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Indicates if a restore is in progress or not.
	//
	// RestoreInProgress is a required field
	RestoreInProgress *bool `type:"boolean" required:"true"`

	// ARN of the backup from which the table was restored.
	SourceBackupArn *string `min:"37" type:"string"`

	// ARN of the source table of the backup that is being restored.
	SourceTableArn *string `type:"string"`
}

// String returns the string representation
func (s RestoreSummary) String() string {
	return awsutil.Prettify(s)
}

// The description of the server-side encryption status on the specified table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/SSEDescription
type SSEDescription struct {
	_ struct{} `type:"structure"`

	// The KMS master key ARN used for the KMS encryption.
	KMSMasterKeyArn *string `type:"string"`

	// Server-side encryption type:
	//
	//    * AES256 - Server-side encryption which uses the AES256 algorithm (not
	//    applicable).
	//
	//    * KMS - Server-side encryption which uses AWS Key Management Service.
	//    Key is stored in your account and is managed by AWS KMS (KMS charges apply).
	SSEType SSEType `type:"string" enum:"true"`

	// The current state of server-side encryption:
	//
	//    * ENABLING - Server-side encryption is being enabled.
	//
	//    * ENABLED - Server-side encryption is enabled.
	//
	//    * DISABLING - Server-side encryption is being disabled.
	//
	//    * DISABLED - Server-side encryption is disabled.
	//
	//    * UPDATING - Server-side encryption is being updated.
	Status SSEStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s SSEDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the settings used to enable server-side encryption.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/SSESpecification
type SSESpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether server-side encryption is enabled (true) or disabled (false)
	// on the table. If enabled (true), server-side encryption type is set to KMS.
	// If disabled (false) or not specified, server-side encryption is set to AWS
	// owned CMK.
	Enabled *bool `type:"boolean"`

	// The KMS Master Key (CMK) which should be used for the KMS encryption. To
	// specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name, or
	// alias ARN. Note that you should only provide this parameter if the key is
	// different from the default DynamoDB KMS Master Key alias/aws/dynamodb.
	KMSMasterKeyId *string `type:"string"`

	// Server-side encryption type:
	//
	//    * AES256 - Server-side encryption which uses the AES256 algorithm (not
	//    applicable).
	//
	//    * KMS - Server-side encryption which uses AWS Key Management Service.
	//    Key is stored in your account and is managed by AWS KMS (KMS charges apply).
	SSEType SSEType `type:"string" enum:"true"`
}

// String returns the string representation
func (s SSESpecification) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of the table when the backup was created.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/SourceTableDetails
type SourceTableDetails struct {
	_ struct{} `type:"structure"`

	// Controls how you are charged for read and write throughput and how you manage
	// capacity. This setting can be changed later.
	//
	//    * PROVISIONED - Sets the read/write capacity mode to PROVISIONED. We recommend
	//    using PROVISIONED for predictable workloads.
	//
	//    * PAY_PER_REQUEST - Sets the read/write capacity mode to PAY_PER_REQUEST.
	//    We recommend using PAY_PER_REQUEST for unpredictable workloads.
	BillingMode BillingMode `type:"string" enum:"true"`

	// Number of items in the table. Please note this is an approximate value.
	ItemCount *int64 `type:"long"`

	// Schema of the table.
	//
	// KeySchema is a required field
	KeySchema []KeySchemaElement `min:"1" type:"list" required:"true"`

	// Read IOPs and Write IOPS on the table when the backup was created.
	//
	// ProvisionedThroughput is a required field
	ProvisionedThroughput *ProvisionedThroughput `type:"structure" required:"true"`

	// ARN of the table for which backup was created.
	TableArn *string `type:"string"`

	// Time when the source table was created.
	//
	// TableCreationDateTime is a required field
	TableCreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Unique identifier for the table for which the backup was created.
	//
	// TableId is a required field
	TableId *string `type:"string" required:"true"`

	// The name of the table for which the backup was created.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// Size of the table in bytes. Please note this is an approximate value.
	TableSizeBytes *int64 `type:"long"`
}

// String returns the string representation
func (s SourceTableDetails) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of the features enabled on the table when the backup
// was created. For example, LSIs, GSIs, streams, TTL.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/SourceTableFeatureDetails
type SourceTableFeatureDetails struct {
	_ struct{} `type:"structure"`

	// Represents the GSI properties for the table when the backup was created.
	// It includes the IndexName, KeySchema, Projection and ProvisionedThroughput
	// for the GSIs on the table at the time of backup.
	GlobalSecondaryIndexes []GlobalSecondaryIndexInfo `type:"list"`

	// Represents the LSI properties for the table when the backup was created.
	// It includes the IndexName, KeySchema and Projection for the LSIs on the table
	// at the time of backup.
	LocalSecondaryIndexes []LocalSecondaryIndexInfo `type:"list"`

	// The description of the server-side encryption status on the table when the
	// backup was created.
	SSEDescription *SSEDescription `type:"structure"`

	// Stream settings on the table when the backup was created.
	StreamDescription *StreamSpecification `type:"structure"`

	// Time to Live settings on the table when the backup was created.
	TimeToLiveDescription *TimeToLiveDescription `type:"structure"`
}

// String returns the string representation
func (s SourceTableFeatureDetails) String() string {
	return awsutil.Prettify(s)
}

// Represents the DynamoDB Streams configuration for a table in DynamoDB.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/StreamSpecification
type StreamSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether DynamoDB Streams is enabled (true) or disabled (false)
	// on the table.
	StreamEnabled *bool `type:"boolean"`

	// When an item in the table is modified, StreamViewType determines what information
	// is written to the stream for this table. Valid values for StreamViewType
	// are:
	//
	//    * KEYS_ONLY - Only the key attributes of the modified item are written
	//    to the stream.
	//
	//    * NEW_IMAGE - The entire item, as it appears after it was modified, is
	//    written to the stream.
	//
	//    * OLD_IMAGE - The entire item, as it appeared before it was modified,
	//    is written to the stream.
	//
	//    * NEW_AND_OLD_IMAGES - Both the new and the old item images of the item
	//    are written to the stream.
	StreamViewType StreamViewType `type:"string" enum:"true"`
}

// String returns the string representation
func (s StreamSpecification) String() string {
	return awsutil.Prettify(s)
}

// Represents the properties of a table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TableDescription
type TableDescription struct {
	_ struct{} `type:"structure"`

	// An array of AttributeDefinition objects. Each of these objects describes
	// one attribute in the table and index key schema.
	//
	// Each AttributeDefinition object in this array is composed of:
	//
	//    * AttributeName - The name of the attribute.
	//
	//    * AttributeType - The data type for the attribute.
	AttributeDefinitions []AttributeDefinition `type:"list"`

	// Contains the details for the read/write capacity mode.
	BillingModeSummary *BillingModeSummary `type:"structure"`

	// The date and time when the table was created, in UNIX epoch time (http://www.epochconverter.com/)
	// format.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The global secondary indexes, if any, on the table. Each index is scoped
	// to a given partition key value. Each element is composed of:
	//
	//    * Backfilling - If true, then the index is currently in the backfilling
	//    phase. Backfilling occurs only when a new global secondary index is added
	//    to the table; it is the process by which DynamoDB populates the new index
	//    with data from the table. (This attribute does not appear for indexes
	//    that were created during a CreateTable operation.)
	//
	//    * IndexName - The name of the global secondary index.
	//
	//    * IndexSizeBytes - The total size of the global secondary index, in bytes.
	//    DynamoDB updates this value approximately every six hours. Recent changes
	//    might not be reflected in this value.
	//
	//    * IndexStatus - The current status of the global secondary index: CREATING
	//    - The index is being created. UPDATING - The index is being updated. DELETING
	//    - The index is being deleted. ACTIVE - The index is ready for use.
	//
	//    * ItemCount - The number of items in the global secondary index. DynamoDB
	//    updates this value approximately every six hours. Recent changes might
	//    not be reflected in this value.
	//
	//    * KeySchema - Specifies the complete index key schema. The attribute names
	//    in the key schema must be between 1 and 255 characters (inclusive). The
	//    key schema must begin with the same partition key as the table.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of: ProjectionType - One of the following: KEYS_ONLY
	//    - Only the index and primary keys are projected into the index. INCLUDE
	//    - Only the specified table attributes are projected into the index. The
	//    list of projected attributes are in NonKeyAttributes. ALL - All of the
	//    table attributes are projected into the index. NonKeyAttributes - A list
	//    of one or more non-key attribute names that are projected into the secondary
	//    index. The total count of attributes provided in NonKeyAttributes, summed
	//    across all of the secondary indexes, must not exceed 20. If you project
	//    the same attribute into two different indexes, this counts as two distinct
	//    attributes when determining the total.
	//
	//    * ProvisionedThroughput - The provisioned throughput settings for the
	//    global secondary index, consisting of read and write capacity units, along
	//    with data about increases and decreases.
	//
	// If the table is in the DELETING state, no information about indexes will
	// be returned.
	GlobalSecondaryIndexes []GlobalSecondaryIndexDescription `type:"list"`

	// The number of items in the specified table. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The primary key structure for the table. Each KeySchemaElement consists of:
	//
	//    * AttributeName - The name of the attribute.
	//
	//    * KeyType - The role of the attribute: HASH - partition key RANGE - sort
	//    key The partition key of an item is also known as its hash attribute.
	//    The term "hash attribute" derives from DynamoDB' usage of an internal
	//    hash function to evenly distribute data items across partitions, based
	//    on their partition key values. The sort key of an item is also known as
	//    its range attribute. The term "range attribute" derives from the way DynamoDB
	//    stores items with the same partition key physically close together, in
	//    sorted order by the sort key value.
	//
	// For more information about primary keys, see Primary Key (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey)
	// in the Amazon DynamoDB Developer Guide.
	KeySchema []KeySchemaElement `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) that uniquely identifies the latest stream
	// for this table.
	LatestStreamArn *string `min:"37" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//    * the AWS customer ID.
	//
	//    * the table name.
	//
	//    * the StreamLabel.
	LatestStreamLabel *string `type:"string"`

	// Represents one or more local secondary indexes on the table. Each index is
	// scoped to a given partition key value. Tables with one or more local secondary
	// indexes are subject to an item collection size limit, where the amount of
	// data within a given item collection cannot exceed 10 GB. Each element is
	// composed of:
	//
	//    * IndexName - The name of the local secondary index.
	//
	//    * KeySchema - Specifies the complete index key schema. The attribute names
	//    in the key schema must be between 1 and 255 characters (inclusive). The
	//    key schema must begin with the same partition key as the table.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of: ProjectionType - One of the following: KEYS_ONLY
	//    - Only the index and primary keys are projected into the index. INCLUDE
	//    - Only the specified table attributes are projected into the index. The
	//    list of projected attributes are in NonKeyAttributes. ALL - All of the
	//    table attributes are projected into the index. NonKeyAttributes - A list
	//    of one or more non-key attribute names that are projected into the secondary
	//    index. The total count of attributes provided in NonKeyAttributes, summed
	//    across all of the secondary indexes, must not exceed 20. If you project
	//    the same attribute into two different indexes, this counts as two distinct
	//    attributes when determining the total.
	//
	//    * IndexSizeBytes - Represents the total size of the index, in bytes. DynamoDB
	//    updates this value approximately every six hours. Recent changes might
	//    not be reflected in this value.
	//
	//    * ItemCount - Represents the number of items in the index. DynamoDB updates
	//    this value approximately every six hours. Recent changes might not be
	//    reflected in this value.
	//
	// If the table is in the DELETING state, no information about indexes will
	// be returned.
	LocalSecondaryIndexes []LocalSecondaryIndexDescription `type:"list"`

	// The provisioned throughput settings for the table, consisting of read and
	// write capacity units, along with data about increases and decreases.
	ProvisionedThroughput *ProvisionedThroughputDescription `type:"structure"`

	// Contains details for the restore.
	RestoreSummary *RestoreSummary `type:"structure"`

	// The description of the server-side encryption status on the specified table.
	SSEDescription *SSEDescription `type:"structure"`

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *StreamSpecification `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the table.
	TableArn *string `type:"string"`

	// Unique identifier for the table for which the backup was created.
	TableId *string `type:"string"`

	// The name of the table.
	TableName *string `min:"3" type:"string"`

	// The total size of the specified table, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	TableSizeBytes *int64 `type:"long"`

	// The current state of the table:
	//
	//    * CREATING - The table is being created.
	//
	//    * UPDATING - The table is being updated.
	//
	//    * DELETING - The table is being deleted.
	//
	//    * ACTIVE - The table is ready for use.
	TableStatus TableStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s TableDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes a tag. A tag is a key-value pair. You can add up to 50 tags to
// a single DynamoDB table.
//
// AWS-assigned tag names and values are automatically assigned the aws: prefix,
// which the user cannot assign. AWS-assigned tag names do not count towards
// the tag limit of 50. User-assigned tag names have the prefix user: in the
// Cost Allocation Report. You cannot backdate the application of a tag.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.Tag keys are case sensitive. Each DynamoDB table can only
	// have up to one tag with the same key. If you try to add an existing tag (same
	// key), the existing tag value will be updated to the new value.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag. Tag values are case-sensitive and can be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The description of the Time to Live (TTL) status on the specified table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TimeToLiveDescription
type TimeToLiveDescription struct {
	_ struct{} `type:"structure"`

	// The name of the Time to Live attribute for items in the table.
	AttributeName *string `min:"1" type:"string"`

	// The Time to Live status for the table.
	TimeToLiveStatus TimeToLiveStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s TimeToLiveDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents the settings used to enable or disable Time to Live for the specified
// table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TimeToLiveSpecification
type TimeToLiveSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the Time to Live attribute used to store the expiration time
	// for items in the table.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// Indicates whether Time To Live is to be enabled (true) or disabled (false)
	// on the table.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s TimeToLiveSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeToLiveSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TimeToLiveSpecification"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an item to be retrieved as part of the transaction.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItem
type TransactGetItem struct {
	_ struct{} `type:"structure"`

	// Contains the primary key that identifies the item to get, together with the
	// name of the table that contains the item, and optionally the specific attributes
	// of the item to retrieve.
	//
	// Get is a required field
	Get *Get `type:"structure" required:"true"`
}

// String returns the string representation
func (s TransactGetItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransactGetItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransactGetItem"}

	if s.Get == nil {
		invalidParams.Add(aws.NewErrParamRequired("Get"))
	}
	if s.Get != nil {
		if err := s.Get.Validate(); err != nil {
			invalidParams.AddNested("Get", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A list of requests that can perform update, put, delete, or check operations
// on multiple items in one or more tables atomically.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactWriteItem
type TransactWriteItem struct {
	_ struct{} `type:"structure"`

	// A request to perform a check item operation.
	ConditionCheck *ConditionCheck `type:"structure"`

	// A request to perform a DeleteItem operation.
	Delete *Delete `type:"structure"`

	// A request to perform a PutItem operation.
	Put *Put `type:"structure"`

	// A request to perform an UpdateItem operation.
	Update *Update `type:"structure"`
}

// String returns the string representation
func (s TransactWriteItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransactWriteItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TransactWriteItem"}
	if s.ConditionCheck != nil {
		if err := s.ConditionCheck.Validate(); err != nil {
			invalidParams.AddNested("ConditionCheck", err.(aws.ErrInvalidParams))
		}
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(aws.ErrInvalidParams))
		}
	}
	if s.Put != nil {
		if err := s.Put.Validate(); err != nil {
			invalidParams.AddNested("Put", err.(aws.ErrInvalidParams))
		}
	}
	if s.Update != nil {
		if err := s.Update.Validate(); err != nil {
			invalidParams.AddNested("Update", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a request to perform an UpdateItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Update
type Update struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional update to succeed.
	ConditionExpression *string `type:"string"`

	// One or more substitution tokens for attribute names in an expression.
	ExpressionAttributeNames map[string]string `type:"map"`

	// One or more values that can be substituted in an expression.
	ExpressionAttributeValues map[string]AttributeValue `type:"map"`

	// The primary key of the item to be updated. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// Key is a required field
	Key map[string]AttributeValue `type:"map" required:"true"`

	// Use ReturnValuesOnConditionCheckFailure to get the item attributes if the
	// Update condition fails. For ReturnValuesOnConditionCheckFailure, the valid
	// values are: NONE, ALL_OLD, UPDATED_OLD, ALL_NEW, UPDATED_NEW.
	ReturnValuesOnConditionCheckFailure ReturnValuesOnConditionCheckFailure `type:"string" enum:"true"`

	// Name of the table for the UpdateItem request.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// An expression that defines one or more attributes to be updated, the action
	// to be performed on them, and new value(s) for them.
	//
	// UpdateExpression is a required field
	UpdateExpression *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Update) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Update) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Update"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 3))
	}

	if s.UpdateExpression == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdateExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the new provisioned throughput settings to be applied to a global
// secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalSecondaryIndexAction
type UpdateGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be updated.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ProvisionedThroughput is a required field
	ProvisionedThroughput *ProvisionedThroughput `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalSecondaryIndexAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGlobalSecondaryIndexAction"}

	if s.IndexName == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexName", 3))
	}

	if s.ProvisionedThroughput == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisionedThroughput"))
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents an operation to perform - either DeleteItem or PutItem. You can
// only request one of these operations, not both, in a single WriteRequest.
// If you do need to perform both of these operations, you will need to provide
// two separate WriteRequest objects.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/WriteRequest
type WriteRequest struct {
	_ struct{} `type:"structure"`

	// A request to perform a DeleteItem operation.
	DeleteRequest *DeleteRequest `type:"structure"`

	// A request to perform a PutItem operation.
	PutRequest *PutRequest `type:"structure"`
}

// String returns the string representation
func (s WriteRequest) String() string {
	return awsutil.Prettify(s)
}
