// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTimeInput
type RestoreTableToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// Time in the past to restore the table to.
	RestoreDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Name of the source table that is being restored.
	//
	// SourceTableName is a required field
	SourceTableName *string `min:"3" type:"string" required:"true"`

	// The name of the new table to which it must be restored to.
	//
	// TargetTableName is a required field
	TargetTableName *string `min:"3" type:"string" required:"true"`

	// Restore the table to the latest possible time. LatestRestorableDateTime is
	// typically 5 minutes before the current time.
	UseLatestRestorableTime *bool `type:"boolean"`
}

// String returns the string representation
func (s RestoreTableToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableToPointInTimeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreTableToPointInTimeInput"}

	if s.SourceTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceTableName"))
	}
	if s.SourceTableName != nil && len(*s.SourceTableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceTableName", 3))
	}

	if s.TargetTableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetTableName"))
	}
	if s.TargetTableName != nil && len(*s.TargetTableName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetTableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTimeOutput
type RestoreTableToPointInTimeOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of a table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s RestoreTableToPointInTimeOutput) String() string {
	return awsutil.Prettify(s)
}

const opRestoreTableToPointInTime = "RestoreTableToPointInTime"

// RestoreTableToPointInTimeRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Restores the specified table to the specified point in time within EarliestRestorableDateTime
// and LatestRestorableDateTime. You can restore your table to any point in
// time during the last 35 days. Any number of users can execute up to 4 concurrent
// restores (any type of restore) in a given account.
//
// When you restore using point in time recovery, DynamoDB restores your table
// data to the state based on the selected date and time (day:hour:minute:second)
// to a new table.
//
// Along with data, the following are also included on the new restored table
// using point in time recovery:
//
//    * Global secondary indexes (GSIs)
//
//    * Local secondary indexes (LSIs)
//
//    * Provisioned read and write capacity
//
//    * Encryption settings All these settings come from the current settings
//    of the source table at the time of restore.
//
// You must manually set up the following on the restored table:
//
//    * Auto scaling policies
//
//    * IAM policies
//
//    * Cloudwatch metrics and alarms
//
//    * Tags
//
//    * Stream settings
//
//    * Time to Live (TTL) settings
//
//    * Point in time recovery settings
//
//    // Example sending a request using RestoreTableToPointInTimeRequest.
//    req := client.RestoreTableToPointInTimeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTime
func (c *Client) RestoreTableToPointInTimeRequest(input *RestoreTableToPointInTimeInput) RestoreTableToPointInTimeRequest {
	op := &aws.Operation{
		Name:       opRestoreTableToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableToPointInTimeInput{}
	}

	req := c.newRequest(op, input, &RestoreTableToPointInTimeOutput{})
	return RestoreTableToPointInTimeRequest{Request: req, Input: input, Copy: c.RestoreTableToPointInTimeRequest}
}

// RestoreTableToPointInTimeRequest is the request type for the
// RestoreTableToPointInTime API operation.
type RestoreTableToPointInTimeRequest struct {
	*aws.Request
	Input *RestoreTableToPointInTimeInput
	Copy  func(*RestoreTableToPointInTimeInput) RestoreTableToPointInTimeRequest
}

// Send marshals and sends the RestoreTableToPointInTime API request.
func (r RestoreTableToPointInTimeRequest) Send(ctx context.Context) (*RestoreTableToPointInTimeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreTableToPointInTimeResponse{
		RestoreTableToPointInTimeOutput: r.Request.Data.(*RestoreTableToPointInTimeOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreTableToPointInTimeResponse is the response type for the
// RestoreTableToPointInTime API operation.
type RestoreTableToPointInTimeResponse struct {
	*RestoreTableToPointInTimeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreTableToPointInTime request.
func (r *RestoreTableToPointInTimeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
