// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptionsRequest
type ListLogSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// If a DirectoryID is provided, lists only the log subscription associated
	// with that directory. If no DirectoryId is provided, lists all log subscriptions
	// associated with your AWS account. If there are no log subscriptions for the
	// AWS account or the directory, an empty list will be returned.
	DirectoryId *string `type:"string"`

	// The maximum number of items returned.
	Limit *int64 `type:"integer"`

	// The token for the next set of items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLogSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptionsResult
type ListLogSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of active LogSubscription objects for calling the AWS account.
	LogSubscriptions []LogSubscription `type:"list"`

	// The token for the next set of items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLogSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLogSubscriptions = "ListLogSubscriptions"

// ListLogSubscriptionsRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Lists the active log subscriptions for the AWS account.
//
//    // Example sending a request using ListLogSubscriptionsRequest.
//    req := client.ListLogSubscriptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions
func (c *Client) ListLogSubscriptionsRequest(input *ListLogSubscriptionsInput) ListLogSubscriptionsRequest {
	op := &aws.Operation{
		Name:       opListLogSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLogSubscriptionsInput{}
	}

	req := c.newRequest(op, input, &ListLogSubscriptionsOutput{})
	return ListLogSubscriptionsRequest{Request: req, Input: input, Copy: c.ListLogSubscriptionsRequest}
}

// ListLogSubscriptionsRequest is the request type for the
// ListLogSubscriptions API operation.
type ListLogSubscriptionsRequest struct {
	*aws.Request
	Input *ListLogSubscriptionsInput
	Copy  func(*ListLogSubscriptionsInput) ListLogSubscriptionsRequest
}

// Send marshals and sends the ListLogSubscriptions API request.
func (r ListLogSubscriptionsRequest) Send(ctx context.Context) (*ListLogSubscriptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLogSubscriptionsResponse{
		ListLogSubscriptionsOutput: r.Request.Data.(*ListLogSubscriptionsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListLogSubscriptionsResponse is the response type for the
// ListLogSubscriptions API operation.
type ListLogSubscriptionsResponse struct {
	*ListLogSubscriptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLogSubscriptions request.
func (r *ListLogSubscriptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
