// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Deletes the local side of an existing trust relationship between the AWS
// Managed Microsoft AD directory and the external domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrustRequest
type DeleteTrustInput struct {
	_ struct{} `type:"structure"`

	// Delete a conditional forwarder as part of a DeleteTrustRequest.
	DeleteAssociatedConditionalForwarder *bool `type:"boolean"`

	// The Trust ID of the trust relationship to be deleted.
	//
	// TrustId is a required field
	TrustId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrustInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrustInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTrustInput"}

	if s.TrustId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrustId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteTrust request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrustResult
type DeleteTrustOutput struct {
	_ struct{} `type:"structure"`

	// The Trust ID of the trust relationship that was deleted.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s DeleteTrustOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTrust = "DeleteTrust"

// DeleteTrustRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Deletes an existing trust relationship between your AWS Managed Microsoft
// AD directory and an external domain.
//
//    // Example sending a request using DeleteTrustRequest.
//    req := client.DeleteTrustRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrust
func (c *Client) DeleteTrustRequest(input *DeleteTrustInput) DeleteTrustRequest {
	op := &aws.Operation{
		Name:       opDeleteTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrustInput{}
	}

	req := c.newRequest(op, input, &DeleteTrustOutput{})
	return DeleteTrustRequest{Request: req, Input: input, Copy: c.DeleteTrustRequest}
}

// DeleteTrustRequest is the request type for the
// DeleteTrust API operation.
type DeleteTrustRequest struct {
	*aws.Request
	Input *DeleteTrustInput
	Copy  func(*DeleteTrustInput) DeleteTrustRequest
}

// Send marshals and sends the DeleteTrust API request.
func (r DeleteTrustRequest) Send(ctx context.Context) (*DeleteTrustResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTrustResponse{
		DeleteTrustOutput: r.Request.Data.(*DeleteTrustOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTrustResponse is the response type for the
// DeleteTrust API operation.
type DeleteTrustResponse struct {
	*DeleteTrustOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTrust request.
func (r *DeleteTrustResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
