// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLagsRequest
type DescribeLagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the LAG.
	LagId *string `locationName:"lagId" type:"string"`
}

// String returns the string representation
func (s DescribeLagsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Lags
type DescribeLagsOutput struct {
	_ struct{} `type:"structure"`

	// The LAGs.
	Lags []Lag `locationName:"lags" type:"list"`
}

// String returns the string representation
func (s DescribeLagsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLags = "DescribeLags"

// DescribeLagsRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Describes all your link aggregation groups (LAG) or the specified LAG.
//
//    // Example sending a request using DescribeLagsRequest.
//    req := client.DescribeLagsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLags
func (c *Client) DescribeLagsRequest(input *DescribeLagsInput) DescribeLagsRequest {
	op := &aws.Operation{
		Name:       opDescribeLags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLagsInput{}
	}

	req := c.newRequest(op, input, &DescribeLagsOutput{})
	return DescribeLagsRequest{Request: req, Input: input, Copy: c.DescribeLagsRequest}
}

// DescribeLagsRequest is the request type for the
// DescribeLags API operation.
type DescribeLagsRequest struct {
	*aws.Request
	Input *DescribeLagsInput
	Copy  func(*DescribeLagsInput) DescribeLagsRequest
}

// Send marshals and sends the DescribeLags API request.
func (r DescribeLagsRequest) Send(ctx context.Context) (*DescribeLagsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLagsResponse{
		DescribeLagsOutput: r.Request.Data.(*DescribeLagsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLagsResponse is the response type for the
// DescribeLags API operation.
type DescribeLagsResponse struct {
	*DescribeLagsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLags request.
func (r *DescribeLagsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
