// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the get suite operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuiteRequest
type GetSuiteInput struct {
	_ struct{} `type:"structure"`

	// The suite's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSuiteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSuiteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSuiteInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a get suite request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuiteResult
type GetSuiteOutput struct {
	_ struct{} `type:"structure"`

	// A collection of one or more tests.
	Suite *Suite `locationName:"suite" type:"structure"`
}

// String returns the string representation
func (s GetSuiteOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSuite = "GetSuite"

// GetSuiteRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Gets information about a suite.
//
//    // Example sending a request using GetSuiteRequest.
//    req := client.GetSuiteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite
func (c *Client) GetSuiteRequest(input *GetSuiteInput) GetSuiteRequest {
	op := &aws.Operation{
		Name:       opGetSuite,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSuiteInput{}
	}

	req := c.newRequest(op, input, &GetSuiteOutput{})
	return GetSuiteRequest{Request: req, Input: input, Copy: c.GetSuiteRequest}
}

// GetSuiteRequest is the request type for the
// GetSuite API operation.
type GetSuiteRequest struct {
	*aws.Request
	Input *GetSuiteInput
	Copy  func(*GetSuiteInput) GetSuiteRequest
}

// Send marshals and sends the GetSuite API request.
func (r GetSuiteRequest) Send(ctx context.Context) (*GetSuiteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSuiteResponse{
		GetSuiteOutput: r.Request.Data.(*GetSuiteOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSuiteResponse is the response type for the
// GetSuite API operation.
type GetSuiteResponse struct {
	*GetSuiteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSuite request.
func (r *GetSuiteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
