// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dax

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateSubnetGroupRequest
type CreateSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description for the subnet group
	Description *string `type:"string"`

	// A name for the subnet group. This value is stored as a lowercase string.
	//
	// SubnetGroupName is a required field
	SubnetGroupName *string `type:"string" required:"true"`

	// A list of VPC subnet IDs for the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []string `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubnetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSubnetGroupInput"}

	if s.SubnetGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetGroupName"))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateSubnetGroupResponse
type CreateSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of a CreateSubnetGroup operation.
	SubnetGroup *SubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateSubnetGroup = "CreateSubnetGroup"

// CreateSubnetGroupRequest returns a request value for making API operation for
// Amazon DynamoDB Accelerator (DAX).
//
// Creates a new subnet group.
//
//    // Example sending a request using CreateSubnetGroupRequest.
//    req := client.CreateSubnetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateSubnetGroup
func (c *Client) CreateSubnetGroupRequest(input *CreateSubnetGroupInput) CreateSubnetGroupRequest {
	op := &aws.Operation{
		Name:       opCreateSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubnetGroupInput{}
	}

	req := c.newRequest(op, input, &CreateSubnetGroupOutput{})
	return CreateSubnetGroupRequest{Request: req, Input: input, Copy: c.CreateSubnetGroupRequest}
}

// CreateSubnetGroupRequest is the request type for the
// CreateSubnetGroup API operation.
type CreateSubnetGroupRequest struct {
	*aws.Request
	Input *CreateSubnetGroupInput
	Copy  func(*CreateSubnetGroupInput) CreateSubnetGroupRequest
}

// Send marshals and sends the CreateSubnetGroup API request.
func (r CreateSubnetGroupRequest) Send(ctx context.Context) (*CreateSubnetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSubnetGroupResponse{
		CreateSubnetGroupOutput: r.Request.Data.(*CreateSubnetGroupOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSubnetGroupResponse is the response type for the
// CreateSubnetGroup API operation.
type CreateSubnetGroupResponse struct {
	*CreateSubnetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSubnetGroup request.
func (r *CreateSubnetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
