// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscriptionMessage
type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a source type that you want to subscribe to.
	// Use the DescribeEventCategories action to see a list of event categories.
	EventCategories []string `type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic created for event
	// notification. The ARN is created by Amazon SNS when you create a topic and
	// subscribe to it.
	SnsTopicArn *string `type:"string"`

	// The type of AWS DMS resource that generates the events you want to subscribe
	// to.
	//
	// Valid values: replication-instance | migration-task
	SourceType *string `type:"string"`

	// The name of the AWS DMS event notification subscription to be modified.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEventSubscriptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyEventSubscriptionInput"}

	if s.SubscriptionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscriptionResponse
type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The modified event subscription.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Modifies an existing AWS DMS event notification subscription.
//
//    // Example sending a request using ModifyEventSubscriptionRequest.
//    req := client.ModifyEventSubscriptionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription
func (c *Client) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) ModifyEventSubscriptionRequest {
	op := &aws.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	req := c.newRequest(op, input, &ModifyEventSubscriptionOutput{})
	return ModifyEventSubscriptionRequest{Request: req, Input: input, Copy: c.ModifyEventSubscriptionRequest}
}

// ModifyEventSubscriptionRequest is the request type for the
// ModifyEventSubscription API operation.
type ModifyEventSubscriptionRequest struct {
	*aws.Request
	Input *ModifyEventSubscriptionInput
	Copy  func(*ModifyEventSubscriptionInput) ModifyEventSubscriptionRequest
}

// Send marshals and sends the ModifyEventSubscription API request.
func (r ModifyEventSubscriptionRequest) Send(ctx context.Context) (*ModifyEventSubscriptionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyEventSubscriptionResponse{
		ModifyEventSubscriptionOutput: r.Request.Data.(*ModifyEventSubscriptionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyEventSubscriptionResponse is the response type for the
// ModifyEventSubscription API operation.
type ModifyEventSubscriptionResponse struct {
	*ModifyEventSubscriptionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyEventSubscription request.
func (r *ModifyEventSubscriptionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
