// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroupRequest
type DescribeUserHierarchyGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the hierarchy group to return.
	//
	// HierarchyGroupId is a required field
	HierarchyGroupId *string `location:"uri" locationName:"HierarchyGroupId" type:"string" required:"true"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserHierarchyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserHierarchyGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeUserHierarchyGroupInput"}

	if s.HierarchyGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HierarchyGroupId"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeUserHierarchyGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.HierarchyGroupId != nil {
		v := *s.HierarchyGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "HierarchyGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroupResponse
type DescribeUserHierarchyGroupOutput struct {
	_ struct{} `type:"structure"`

	// Returns a HierarchyGroup object.
	HierarchyGroup *HierarchyGroup `type:"structure"`
}

// String returns the string representation
func (s DescribeUserHierarchyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeUserHierarchyGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.HierarchyGroup != nil {
		v := s.HierarchyGroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HierarchyGroup", v, metadata)
	}
	return nil
}

const opDescribeUserHierarchyGroup = "DescribeUserHierarchyGroup"

// DescribeUserHierarchyGroupRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Returns a HierarchyGroup object that includes information about a hierarchy
// group in your instance.
//
//    // Example sending a request using DescribeUserHierarchyGroupRequest.
//    req := client.DescribeUserHierarchyGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup
func (c *Client) DescribeUserHierarchyGroupRequest(input *DescribeUserHierarchyGroupInput) DescribeUserHierarchyGroupRequest {
	op := &aws.Operation{
		Name:       opDescribeUserHierarchyGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
	}

	if input == nil {
		input = &DescribeUserHierarchyGroupInput{}
	}

	req := c.newRequest(op, input, &DescribeUserHierarchyGroupOutput{})
	return DescribeUserHierarchyGroupRequest{Request: req, Input: input, Copy: c.DescribeUserHierarchyGroupRequest}
}

// DescribeUserHierarchyGroupRequest is the request type for the
// DescribeUserHierarchyGroup API operation.
type DescribeUserHierarchyGroupRequest struct {
	*aws.Request
	Input *DescribeUserHierarchyGroupInput
	Copy  func(*DescribeUserHierarchyGroupInput) DescribeUserHierarchyGroupRequest
}

// Send marshals and sends the DescribeUserHierarchyGroup API request.
func (r DescribeUserHierarchyGroupRequest) Send(ctx context.Context) (*DescribeUserHierarchyGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeUserHierarchyGroupResponse{
		DescribeUserHierarchyGroupOutput: r.Request.Data.(*DescribeUserHierarchyGroupOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeUserHierarchyGroupResponse is the response type for the
// DescribeUserHierarchyGroup API operation.
type DescribeUserHierarchyGroupResponse struct {
	*DescribeUserHierarchyGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeUserHierarchyGroup request.
func (r *DescribeUserHierarchyGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
