// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequestsRequest
type DescribePendingAggregationRequestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of evaluation results returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingAggregationRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequestsResponse
type DescribePendingAggregationRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a PendingAggregationRequests object.
	PendingAggregationRequests []PendingAggregationRequest `type:"list"`
}

// String returns the string representation
func (s DescribePendingAggregationRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePendingAggregationRequests = "DescribePendingAggregationRequests"

// DescribePendingAggregationRequestsRequest returns a request value for making API operation for
// AWS Config.
//
// Returns a list of all pending aggregation requests.
//
//    // Example sending a request using DescribePendingAggregationRequestsRequest.
//    req := client.DescribePendingAggregationRequestsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests
func (c *Client) DescribePendingAggregationRequestsRequest(input *DescribePendingAggregationRequestsInput) DescribePendingAggregationRequestsRequest {
	op := &aws.Operation{
		Name:       opDescribePendingAggregationRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePendingAggregationRequestsInput{}
	}

	req := c.newRequest(op, input, &DescribePendingAggregationRequestsOutput{})
	return DescribePendingAggregationRequestsRequest{Request: req, Input: input, Copy: c.DescribePendingAggregationRequestsRequest}
}

// DescribePendingAggregationRequestsRequest is the request type for the
// DescribePendingAggregationRequests API operation.
type DescribePendingAggregationRequestsRequest struct {
	*aws.Request
	Input *DescribePendingAggregationRequestsInput
	Copy  func(*DescribePendingAggregationRequestsInput) DescribePendingAggregationRequestsRequest
}

// Send marshals and sends the DescribePendingAggregationRequests API request.
func (r DescribePendingAggregationRequestsRequest) Send(ctx context.Context) (*DescribePendingAggregationRequestsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePendingAggregationRequestsResponse{
		DescribePendingAggregationRequestsOutput: r.Request.Data.(*DescribePendingAggregationRequestsOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePendingAggregationRequestsResponse is the response type for the
// DescribePendingAggregationRequests API operation.
type DescribePendingAggregationRequestsResponse struct {
	*DescribePendingAggregationRequestsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePendingAggregationRequests request.
func (r *DescribePendingAggregationRequestsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
