// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRuleRequest
type DescribeComplianceByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT and NON_COMPLIANT.
	ComplianceTypes []ComplianceType `type:"list"`

	// Specify one or more AWS Config rule names to filter the results by rule.
	ConfigRuleNames []string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRuleResponse
type DescribeComplianceByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether each of the specified AWS Config rules is compliant.
	ComplianceByConfigRules []ComplianceByConfigRule `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeComplianceByConfigRule = "DescribeComplianceByConfigRule"

// DescribeComplianceByConfigRuleRequest returns a request value for making API operation for
// AWS Config.
//
// Indicates whether the specified AWS Config rules are compliant. If a rule
// is noncompliant, this action returns the number of AWS resources that do
// not comply with the rule.
//
// A rule is compliant if all of the evaluated resources comply with it. It
// is noncompliant if any of these resources do not comply.
//
// If AWS Config has no current evaluation results for the rule, it returns
// INSUFFICIENT_DATA. This result might indicate one of the following conditions:
//
//    * AWS Config has never invoked an evaluation for the rule. To check whether
//    it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime
//    and LastFailedInvocationTime.
//
//    * The rule's AWS Lambda function is failing to send evaluation results
//    to AWS Config. Verify that the role you assigned to your configuration
//    recorder includes the config:PutEvaluations permission. If the rule is
//    a custom rule, verify that the AWS Lambda execution role includes the
//    config:PutEvaluations permission.
//
//    * The rule's AWS Lambda function has returned NOT_APPLICABLE for all evaluation
//    results. This can occur if the resources were deleted or removed from
//    the rule's scope.
//
//    // Example sending a request using DescribeComplianceByConfigRuleRequest.
//    req := client.DescribeComplianceByConfigRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule
func (c *Client) DescribeComplianceByConfigRuleRequest(input *DescribeComplianceByConfigRuleInput) DescribeComplianceByConfigRuleRequest {
	op := &aws.Operation{
		Name:       opDescribeComplianceByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComplianceByConfigRuleInput{}
	}

	req := c.newRequest(op, input, &DescribeComplianceByConfigRuleOutput{})
	return DescribeComplianceByConfigRuleRequest{Request: req, Input: input, Copy: c.DescribeComplianceByConfigRuleRequest}
}

// DescribeComplianceByConfigRuleRequest is the request type for the
// DescribeComplianceByConfigRule API operation.
type DescribeComplianceByConfigRuleRequest struct {
	*aws.Request
	Input *DescribeComplianceByConfigRuleInput
	Copy  func(*DescribeComplianceByConfigRuleInput) DescribeComplianceByConfigRuleRequest
}

// Send marshals and sends the DescribeComplianceByConfigRule API request.
func (r DescribeComplianceByConfigRuleRequest) Send(ctx context.Context) (*DescribeComplianceByConfigRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeComplianceByConfigRuleResponse{
		DescribeComplianceByConfigRuleOutput: r.Request.Data.(*DescribeComplianceByConfigRuleOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeComplianceByConfigRuleResponse is the response type for the
// DescribeComplianceByConfigRule API operation.
type DescribeComplianceByConfigRuleResponse struct {
	*DescribeComplianceByConfigRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeComplianceByConfigRule request.
func (r *DescribeComplianceByConfigRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
