// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// An extracted segment of the text that is an attribute of an entity, or otherwise
// related to an entity, such as the dosage of a medication taken. It contains
// information about the attribute such as id, begin and end offset within the
// input text, and the segment of the input text.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/Attribute
type Attribute struct {
	_ struct{} `type:"structure"`

	// The 0-based character offset in the input text that shows where the attribute
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The 0-based character offset in the input text that shows where the attribute
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for this attribute. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Comprehend Medical has that this attribute is
	// correctly related to this entity.
	RelationshipScore *float64 `type:"float"`

	// The level of confidence that Comprehend Medical has that the segment of text
	// is correctly recognized as an attribute.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this attribute.
	Text *string `min:"1" type:"string"`

	// Contextual information for this attribute.
	Traits []Trait `type:"list"`

	// The type of attribute.
	Type EntitySubType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// Provides information about an extracted medical entity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/Entity
type Entity struct {
	_ struct{} `type:"structure"`

	// The extracted attributes that relate to this entity.
	Attributes []Attribute `type:"list"`

	// The 0-based character offset in the input text that shows where the entity
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of the entity.
	Category EntityType `type:"string" enum:"true"`

	// The 0-based character offset in the input text that shows where the entity
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for the entity. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Comprehend Medical has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this entity.
	Text *string `min:"1" type:"string"`

	// Contextual information for the entity
	Traits []Trait `type:"list"`

	// Describes the specific type of entity with category of entities.
	Type EntitySubType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// Provides contextual information about the extracted entity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/Trait
type Trait struct {
	_ struct{} `type:"structure"`

	// Provides a name or contextual description about the trait.
	Name AttributeName `type:"string" enum:"true"`

	// The level of confidence that Comprehend Medical has in the accuracy of this
	// trait.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s Trait) String() string {
	return awsutil.Prettify(s)
}

// An attribute that we extracted, but were unable to relate to an entity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/UnmappedAttribute
type UnmappedAttribute struct {
	_ struct{} `type:"structure"`

	// The specific attribute that has been extracted but not mapped to an entity.
	Attribute *Attribute `type:"structure"`

	// The type of the attribute, could be one of the following values: "MEDICATION",
	// "MEDICAL_CONDITION", "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PERSONAL_HEALTH_INFORMATION".
	Type EntityType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UnmappedAttribute) String() string {
	return awsutil.Prettify(s)
}
