// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProvidersRequest
type ListIdentityProvidersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of identity providers to return.
	MaxResults *int64 `type:"integer"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListIdentityProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityProvidersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListIdentityProvidersInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProvidersResponse
type ListIdentityProvidersOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`

	// A list of identity provider objects.
	//
	// Providers is a required field
	Providers []ProviderDescription `type:"list" required:"true"`
}

// String returns the string representation
func (s ListIdentityProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListIdentityProviders = "ListIdentityProviders"

// ListIdentityProvidersRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Lists information about all identity providers for a user pool.
//
//    // Example sending a request using ListIdentityProvidersRequest.
//    req := client.ListIdentityProvidersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListIdentityProviders
func (c *Client) ListIdentityProvidersRequest(input *ListIdentityProvidersInput) ListIdentityProvidersRequest {
	op := &aws.Operation{
		Name:       opListIdentityProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentityProvidersInput{}
	}

	req := c.newRequest(op, input, &ListIdentityProvidersOutput{})
	return ListIdentityProvidersRequest{Request: req, Input: input, Copy: c.ListIdentityProvidersRequest}
}

// ListIdentityProvidersRequest is the request type for the
// ListIdentityProviders API operation.
type ListIdentityProvidersRequest struct {
	*aws.Request
	Input *ListIdentityProvidersInput
	Copy  func(*ListIdentityProvidersInput) ListIdentityProvidersRequest
}

// Send marshals and sends the ListIdentityProviders API request.
func (r ListIdentityProvidersRequest) Send(ctx context.Context) (*ListIdentityProvidersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListIdentityProvidersResponse{
		ListIdentityProvidersOutput: r.Request.Data.(*ListIdentityProvidersOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListIdentityProvidersRequestPaginator returns a paginator for ListIdentityProviders.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListIdentityProvidersRequest(input)
//   p := cognitoidentityprovider.NewListIdentityProvidersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListIdentityProvidersPaginator(req ListIdentityProvidersRequest) ListIdentityProvidersPaginator {
	return ListIdentityProvidersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListIdentityProvidersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListIdentityProvidersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListIdentityProvidersPaginator struct {
	aws.Pager
}

func (p *ListIdentityProvidersPaginator) CurrentPage() *ListIdentityProvidersOutput {
	return p.Pager.CurrentPage().(*ListIdentityProvidersOutput)
}

// ListIdentityProvidersResponse is the response type for the
// ListIdentityProviders API operation.
type ListIdentityProvidersResponse struct {
	*ListIdentityProvidersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListIdentityProviders request.
func (r *ListIdentityProvidersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
