// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroupRequest
type AdminAddUserToGroupInput struct {
	_ struct{} `type:"structure"`

	// The group name.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminAddUserToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminAddUserToGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminAddUserToGroupInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroupOutput
type AdminAddUserToGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminAddUserToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminAddUserToGroup = "AdminAddUserToGroup"

// AdminAddUserToGroupRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Adds the specified user to the specified group.
//
// Requires developer credentials.
//
//    // Example sending a request using AdminAddUserToGroupRequest.
//    req := client.AdminAddUserToGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminAddUserToGroup
func (c *Client) AdminAddUserToGroupRequest(input *AdminAddUserToGroupInput) AdminAddUserToGroupRequest {
	op := &aws.Operation{
		Name:       opAdminAddUserToGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminAddUserToGroupInput{}
	}

	req := c.newRequest(op, input, &AdminAddUserToGroupOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AdminAddUserToGroupRequest{Request: req, Input: input, Copy: c.AdminAddUserToGroupRequest}
}

// AdminAddUserToGroupRequest is the request type for the
// AdminAddUserToGroup API operation.
type AdminAddUserToGroupRequest struct {
	*aws.Request
	Input *AdminAddUserToGroupInput
	Copy  func(*AdminAddUserToGroupInput) AdminAddUserToGroupRequest
}

// Send marshals and sends the AdminAddUserToGroup API request.
func (r AdminAddUserToGroupRequest) Send(ctx context.Context) (*AdminAddUserToGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminAddUserToGroupResponse{
		AdminAddUserToGroupOutput: r.Request.Data.(*AdminAddUserToGroupOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminAddUserToGroupResponse is the response type for the
// AdminAddUserToGroup API operation.
type AdminAddUserToGroupResponse struct {
	*AdminAddUserToGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminAddUserToGroup request.
func (r *AdminAddUserToGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
