// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Input to the UnlinkIdentity action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkIdentityInput
type UnlinkIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	//
	// IdentityId is a required field
	IdentityId *string `min:"1" type:"string" required:"true"`

	// A set of optional name-value pairs that map provider names to provider tokens.
	//
	// Logins is a required field
	Logins map[string]string `type:"map" required:"true"`

	// Provider names to unlink from this identity.
	//
	// LoginsToRemove is a required field
	LoginsToRemove []string `type:"list" required:"true"`
}

// String returns the string representation
func (s UnlinkIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnlinkIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnlinkIdentityInput"}

	if s.IdentityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityId", 1))
	}

	if s.Logins == nil {
		invalidParams.Add(aws.NewErrParamRequired("Logins"))
	}

	if s.LoginsToRemove == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoginsToRemove"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkIdentityOutput
type UnlinkIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnlinkIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

const opUnlinkIdentity = "UnlinkIdentity"

// UnlinkIdentityRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Unlinks a federated identity from an existing account. Unlinked logins will
// be considered new identities next time they are seen. Removing the last linked
// login will make this identity inaccessible.
//
// This is a public API. You do not need any credentials to call this API.
//
//    // Example sending a request using UnlinkIdentityRequest.
//    req := client.UnlinkIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/UnlinkIdentity
func (c *Client) UnlinkIdentityRequest(input *UnlinkIdentityInput) UnlinkIdentityRequest {
	op := &aws.Operation{
		Name:       opUnlinkIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnlinkIdentityInput{}
	}

	req := c.newRequest(op, input, &UnlinkIdentityOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	req.Config.Credentials = aws.AnonymousCredentials
	return UnlinkIdentityRequest{Request: req, Input: input, Copy: c.UnlinkIdentityRequest}
}

// UnlinkIdentityRequest is the request type for the
// UnlinkIdentity API operation.
type UnlinkIdentityRequest struct {
	*aws.Request
	Input *UnlinkIdentityInput
	Copy  func(*UnlinkIdentityInput) UnlinkIdentityRequest
}

// Send marshals and sends the UnlinkIdentity API request.
func (r UnlinkIdentityRequest) Send(ctx context.Context) (*UnlinkIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnlinkIdentityResponse{
		UnlinkIdentityOutput: r.Request.Data.(*UnlinkIdentityOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnlinkIdentityResponse is the response type for the
// UnlinkIdentity API operation.
type UnlinkIdentityResponse struct {
	*UnlinkIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnlinkIdentity request.
func (r *UnlinkIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
