// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Input to the ListIdentityPools action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPoolsInput
type ListIdentityPoolsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of identities to return.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityPoolsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListIdentityPoolsInput"}

	if s.MaxResults == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a successful ListIdentityPools action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPoolsResponse
type ListIdentityPoolsOutput struct {
	_ struct{} `type:"structure"`

	// The identity pools returned by the ListIdentityPools action.
	IdentityPools []IdentityPoolShortDescription `type:"list"`

	// A pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListIdentityPools = "ListIdentityPools"

// ListIdentityPoolsRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Lists all of the Cognito identity pools registered for your account.
//
// You must use AWS Developer credentials to call this API.
//
//    // Example sending a request using ListIdentityPoolsRequest.
//    req := client.ListIdentityPoolsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/ListIdentityPools
func (c *Client) ListIdentityPoolsRequest(input *ListIdentityPoolsInput) ListIdentityPoolsRequest {
	op := &aws.Operation{
		Name:       opListIdentityPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentityPoolsInput{}
	}

	req := c.newRequest(op, input, &ListIdentityPoolsOutput{})
	return ListIdentityPoolsRequest{Request: req, Input: input, Copy: c.ListIdentityPoolsRequest}
}

// ListIdentityPoolsRequest is the request type for the
// ListIdentityPools API operation.
type ListIdentityPoolsRequest struct {
	*aws.Request
	Input *ListIdentityPoolsInput
	Copy  func(*ListIdentityPoolsInput) ListIdentityPoolsRequest
}

// Send marshals and sends the ListIdentityPools API request.
func (r ListIdentityPoolsRequest) Send(ctx context.Context) (*ListIdentityPoolsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListIdentityPoolsResponse{
		ListIdentityPoolsOutput: r.Request.Data.(*ListIdentityPoolsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListIdentityPoolsResponse is the response type for the
// ListIdentityPools API operation.
type ListIdentityPoolsResponse struct {
	*ListIdentityPoolsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListIdentityPools request.
func (r *ListIdentityPoolsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
