// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about a build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/Build
type Build struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the build.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Information about the output artifacts for the build.
	Artifacts *BuildArtifacts `locationName:"artifacts" type:"structure"`

	// Whether the build is complete. True if complete; otherwise, false.
	BuildComplete *bool `locationName:"buildComplete" type:"boolean"`

	// The current status of the build. Valid values include:
	//
	//    * FAILED: The build failed.
	//
	//    * FAULT: The build faulted.
	//
	//    * IN_PROGRESS: The build is still in progress.
	//
	//    * STOPPED: The build stopped.
	//
	//    * SUCCEEDED: The build succeeded.
	//
	//    * TIMED_OUT: The build timed out.
	BuildStatus StatusType `locationName:"buildStatus" type:"string" enum:"true"`

	// Information about the cache for the build.
	Cache *ProjectCache `locationName:"cache" type:"structure"`

	// The current build phase.
	CurrentPhase *string `locationName:"currentPhase" type:"string"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// You can use a cross-account KMS key to encrypt the build output artifacts
	// if your service role has permission to that key.
	//
	// You can specify either the Amazon Resource Name (ARN) of the CMK or, if available,
	// the CMK's alias (using the format alias/alias-name ).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// When the build process ended, expressed in Unix time format.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// Information about the build environment for this build.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// The unique ID for the build.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The entity that started the build. Valid values include:
	//
	//    * If AWS CodePipeline started the build, the pipeline's name (for example,
	//    codepipeline/my-demo-pipeline).
	//
	//    * If an AWS Identity and Access Management (IAM) user started the build,
	//    the user's name (for example, MyUserName).
	//
	//    * If the Jenkins plugin for AWS CodeBuild started the build, the string
	//    CodeBuild-Jenkins-Plugin.
	Initiator *string `locationName:"initiator" type:"string"`

	// Information about the build's logs in Amazon CloudWatch Logs.
	Logs *LogsLocation `locationName:"logs" type:"structure"`

	// Describes a network interface.
	NetworkInterface *NetworkInterface `locationName:"networkInterface" type:"structure"`

	// Information about all previous build phases that are complete and information
	// about any current build phase that is not yet complete.
	Phases []BuildPhase `locationName:"phases" type:"list"`

	// The name of the AWS CodeBuild project.
	ProjectName *string `locationName:"projectName" min:"1" type:"string"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutes *int64 `locationName:"queuedTimeoutInMinutes" type:"integer"`

	// An identifier for the version of this build's source code.
	//
	//    * For AWS CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit
	//    ID.
	//
	//    * For AWS CodePipeline, the source revision provided by AWS CodePipeline.
	//
	//    * For Amazon Simple Storage Service (Amazon S3), this does not apply.
	ResolvedSourceVersion *string `locationName:"resolvedSourceVersion" min:"1" type:"string"`

	// An array of ProjectArtifacts objects.
	SecondaryArtifacts []BuildArtifacts `locationName:"secondaryArtifacts" type:"list"`

	// An array of ProjectSourceVersion objects. Each ProjectSourceVersion must
	// be one of:
	//
	//    * For AWS CodeCommit: the commit ID to use.
	//
	//    * For GitHub: the commit ID, pull request ID, branch name, or tag name
	//    that corresponds to the version of the source code you want to build.
	//    If a pull request ID is specified, it must use the format pr/pull-request-ID
	//    (for example, pr/25). If a branch name is specified, the branch's HEAD
	//    commit ID is used. If not specified, the default branch's HEAD commit
	//    ID is used.
	//
	//    * For Bitbucket: the commit ID, branch name, or tag name that corresponds
	//    to the version of the source code you want to build. If a branch name
	//    is specified, the branch's HEAD commit ID is used. If not specified, the
	//    default branch's HEAD commit ID is used.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object that represents the build input ZIP file to use.
	SecondarySourceVersions []ProjectSourceVersion `locationName:"secondarySourceVersions" type:"list"`

	// An array of ProjectSource objects.
	SecondarySources []ProjectSource `locationName:"secondarySources" type:"list"`

	// The name of a service role used for this build.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information about the source code to be built.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// Any version identifier for the version of the source code to be built.
	SourceVersion *string `locationName:"sourceVersion" min:"1" type:"string"`

	// When the build process started, expressed in Unix time format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// How long, in minutes, for AWS CodeBuild to wait before timing out this build
	// if it does not get marked as completed.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" type:"integer"`

	// If your AWS CodeBuild project accesses resources in an Amazon VPC, you provide
	// this parameter that identifies the VPC ID and the list of security group
	// IDs and subnet IDs. The security groups and subnets must belong to the same
	// VPC. You must provide at least one security group and one subnet ID.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// Information about build output artifacts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BuildArtifacts
type BuildArtifacts struct {
	_ struct{} `type:"structure"`

	// An identifier for this artifact definition.
	ArtifactIdentifier *string `locationName:"artifactIdentifier" type:"string"`

	// Information that tells you if encryption for build artifacts is disabled.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// Information about the location of the build artifacts.
	Location *string `locationName:"location" type:"string"`

	// The MD5 hash of the build artifact.
	//
	// You can use this hash along with a checksum tool to confirm file integrity
	// and authenticity.
	//
	// This value is available only if the build project's packaging value is set
	// to ZIP.
	Md5sum *string `locationName:"md5sum" type:"string"`

	// If this flag is set, a name specified in the build spec file overrides the
	// artifact name. The name specified in a build spec file is calculated at build
	// time and uses the Shell Command Language. For example, you can append a date
	// and time to your artifact name so that it is always unique.
	OverrideArtifactName *bool `locationName:"overrideArtifactName" type:"boolean"`

	// The SHA-256 hash of the build artifact.
	//
	// You can use this hash along with a checksum tool to confirm file integrity
	// and authenticity.
	//
	// This value is available only if the build project's packaging value is set
	// to ZIP.
	Sha256sum *string `locationName:"sha256sum" type:"string"`
}

// String returns the string representation
func (s BuildArtifacts) String() string {
	return awsutil.Prettify(s)
}

// Information about a build that could not be successfully deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BuildNotDeleted
type BuildNotDeleted struct {
	_ struct{} `type:"structure"`

	// The ID of the build that could not be successfully deleted.
	Id *string `locationName:"id" min:"1" type:"string"`

	// Additional information about the build that could not be successfully deleted.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s BuildNotDeleted) String() string {
	return awsutil.Prettify(s)
}

// Information about a stage for a build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/BuildPhase
type BuildPhase struct {
	_ struct{} `type:"structure"`

	// Additional information about a build phase, especially to help troubleshoot
	// a failed build.
	Contexts []PhaseContext `locationName:"contexts" type:"list"`

	// How long, in seconds, between the starting and ending times of the build's
	// phase.
	DurationInSeconds *int64 `locationName:"durationInSeconds" type:"long"`

	// When the build phase ended, expressed in Unix time format.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// The current status of the build phase. Valid values include:
	//
	//    * FAILED: The build phase failed.
	//
	//    * FAULT: The build phase faulted.
	//
	//    * IN_PROGRESS: The build phase is still in progress.
	//
	//    * QUEUED: The build has been submitted and is queued behind other submitted
	//    builds.
	//
	//    * STOPPED: The build phase stopped.
	//
	//    * SUCCEEDED: The build phase succeeded.
	//
	//    * TIMED_OUT: The build phase timed out.
	PhaseStatus StatusType `locationName:"phaseStatus" type:"string" enum:"true"`

	// The name of the build phase. Valid values include:
	//
	//    * BUILD: Core build activities typically occur in this build phase.
	//
	//    * COMPLETED: The build has been completed.
	//
	//    * DOWNLOAD_SOURCE: Source code is being downloaded in this build phase.
	//
	//    * FINALIZING: The build process is completing in this build phase.
	//
	//    * INSTALL: Installation activities typically occur in this build phase.
	//
	//    * POST_BUILD: Post-build activities typically occur in this build phase.
	//
	//    * PRE_BUILD: Pre-build activities typically occur in this build phase.
	//
	//    * PROVISIONING: The build environment is being set up.
	//
	//    * QUEUED: The build has been submitted and is queued behind other submitted
	//    builds.
	//
	//    * SUBMITTED: The build has been submitted.
	//
	//    * UPLOAD_ARTIFACTS: Build output artifacts are being uploaded to the output
	//    location.
	PhaseType BuildPhaseType `locationName:"phaseType" type:"string" enum:"true"`

	// When the build phase started, expressed in Unix time format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s BuildPhase) String() string {
	return awsutil.Prettify(s)
}

// Information about Amazon CloudWatch Logs for a build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/CloudWatchLogsConfig
type CloudWatchLogsConfig struct {
	_ struct{} `type:"structure"`

	// The group name of the logs in Amazon CloudWatch Logs. For more information,
	// see Working with Log Groups and Log Streams (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
	GroupName *string `locationName:"groupName" type:"string"`

	// The current status of the logs in Amazon CloudWatch Logs for a build project.
	// Valid values are:
	//
	//    * ENABLED: Amazon CloudWatch Logs are enabled for this build project.
	//
	//    * DISABLED: Amazon CloudWatch Logs are not enabled for this build project.
	//
	// Status is a required field
	Status LogsConfigStatusType `locationName:"status" type:"string" required:"true" enum:"true"`

	// The prefix of the stream name of the Amazon CloudWatch Logs. For more information,
	// see Working with Log Groups and Log Streams (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html).
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s CloudWatchLogsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchLogsConfig"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a Docker image that is managed by AWS CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/EnvironmentImage
type EnvironmentImage struct {
	_ struct{} `type:"structure"`

	// The description of the Docker image.
	Description *string `locationName:"description" type:"string"`

	// The name of the Docker image.
	Name *string `locationName:"name" type:"string"`

	// A list of environment image versions.
	Versions []string `locationName:"versions" type:"list"`
}

// String returns the string representation
func (s EnvironmentImage) String() string {
	return awsutil.Prettify(s)
}

// A set of Docker images that are related by programming language and are managed
// by AWS CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/EnvironmentLanguage
type EnvironmentLanguage struct {
	_ struct{} `type:"structure"`

	// The list of Docker images that are related by the specified programming language.
	Images []EnvironmentImage `locationName:"images" type:"list"`

	// The programming language for the Docker images.
	Language LanguageType `locationName:"language" type:"string" enum:"true"`
}

// String returns the string representation
func (s EnvironmentLanguage) String() string {
	return awsutil.Prettify(s)
}

// A set of Docker images that are related by platform and are managed by AWS
// CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/EnvironmentPlatform
type EnvironmentPlatform struct {
	_ struct{} `type:"structure"`

	// The list of programming languages that are available for the specified platform.
	Languages []EnvironmentLanguage `locationName:"languages" type:"list"`

	// The platform's name.
	Platform PlatformType `locationName:"platform" type:"string" enum:"true"`
}

// String returns the string representation
func (s EnvironmentPlatform) String() string {
	return awsutil.Prettify(s)
}

// Information about an environment variable for a build project or a build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/EnvironmentVariable
type EnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// The name or key of the environment variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The type of environment variable. Valid values include:
	//
	//    * PARAMETER_STORE: An environment variable stored in Amazon EC2 Systems
	//    Manager Parameter Store.
	//
	//    * PLAINTEXT: An environment variable in plaintext format.
	Type EnvironmentVariableType `locationName:"type" type:"string" enum:"true"`

	// The value of the environment variable.
	//
	// We strongly discourage the use of environment variables to store sensitive
	// values, especially AWS secret key IDs and secret access keys. Environment
	// variables can be displayed in plain text using the AWS CodeBuild console
	// and the AWS Command Line Interface (AWS CLI).
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s EnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentVariable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnvironmentVariable"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the Git submodules configuration for an AWS CodeBuild build
// project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/GitSubmodulesConfig
type GitSubmodulesConfig struct {
	_ struct{} `type:"structure"`

	// Set to true to fetch Git submodules for your AWS CodeBuild build project.
	//
	// FetchSubmodules is a required field
	FetchSubmodules *bool `locationName:"fetchSubmodules" type:"boolean" required:"true"`
}

// String returns the string representation
func (s GitSubmodulesConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitSubmodulesConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GitSubmodulesConfig"}

	if s.FetchSubmodules == nil {
		invalidParams.Add(aws.NewErrParamRequired("FetchSubmodules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about logs for a build project. These can be logs in Amazon CloudWatch
// Logs, built in a specified S3 bucket, or both.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/LogsConfig
type LogsConfig struct {
	_ struct{} `type:"structure"`

	// Information about Amazon CloudWatch Logs for a build project. Amazon CloudWatch
	// Logs are enabled by default.
	CloudWatchLogs *CloudWatchLogsConfig `locationName:"cloudWatchLogs" type:"structure"`

	// Information about logs built to an S3 bucket for a build project. S3 logs
	// are not enabled by default.
	S3Logs *S3LogsConfig `locationName:"s3Logs" type:"structure"`
}

// String returns the string representation
func (s LogsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LogsConfig"}
	if s.CloudWatchLogs != nil {
		if err := s.CloudWatchLogs.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogs", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3Logs != nil {
		if err := s.S3Logs.Validate(); err != nil {
			invalidParams.AddNested("S3Logs", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about build logs in Amazon CloudWatch Logs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/LogsLocation
type LogsLocation struct {
	_ struct{} `type:"structure"`

	// Information about Amazon CloudWatch Logs for a build project.
	CloudWatchLogs *CloudWatchLogsConfig `locationName:"cloudWatchLogs" type:"structure"`

	// The URL to an individual build log in Amazon CloudWatch Logs.
	DeepLink *string `locationName:"deepLink" type:"string"`

	// The name of the Amazon CloudWatch Logs group for the build logs.
	GroupName *string `locationName:"groupName" type:"string"`

	// The URL to a build log in an S3 bucket.
	S3DeepLink *string `locationName:"s3DeepLink" type:"string"`

	// Information about S3 logs for a build project.
	S3Logs *S3LogsConfig `locationName:"s3Logs" type:"structure"`

	// The name of the Amazon CloudWatch Logs stream for the build logs.
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s LogsLocation) String() string {
	return awsutil.Prettify(s)
}

// Describes a network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/NetworkInterface
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" min:"1" type:"string"`

	// The ID of the subnet.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// Additional information about a build phase that has an error. You can use
// this information for troubleshooting.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/PhaseContext
type PhaseContext struct {
	_ struct{} `type:"structure"`

	// An explanation of the build phase's context. This might include a command
	// ID and an exit code.
	Message *string `locationName:"message" type:"string"`

	// The status code for the context of the build phase.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation
func (s PhaseContext) String() string {
	return awsutil.Prettify(s)
}

// Information about a build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/Project
type Project struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the build project.
	Arn *string `locationName:"arn" type:"string"`

	// Information about the build output artifacts for the build project.
	Artifacts *ProjectArtifacts `locationName:"artifacts" type:"structure"`

	// Information about the build badge for the build project.
	Badge *ProjectBadge `locationName:"badge" type:"structure"`

	// Information about the cache for the build project.
	Cache *ProjectCache `locationName:"cache" type:"structure"`

	// When the build project was created, expressed in Unix time format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// A description that makes the build project easy to identify.
	Description *string `locationName:"description" type:"string"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
	// used for encrypting the build output artifacts.
	//
	// You can use a cross-account KMS key to encrypt the build output artifacts
	// if your service role has permission to that key.
	//
	// You can specify either the Amazon Resource Name (ARN) of the CMK or, if available,
	// the CMK's alias (using the format alias/alias-name ).
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// Information about the build environment for this build project.
	Environment *ProjectEnvironment `locationName:"environment" type:"structure"`

	// When the build project's settings were last modified, expressed in Unix time
	// format.
	LastModified *time.Time `locationName:"lastModified" type:"timestamp" timestampFormat:"unix"`

	// Information about logs for the build project. A project can create logs in
	// Amazon CloudWatch Logs, an S3 bucket, or both.
	LogsConfig *LogsConfig `locationName:"logsConfig" type:"structure"`

	// The name of the build project.
	Name *string `locationName:"name" min:"2" type:"string"`

	// The number of minutes a build is allowed to be queued before it times out.
	QueuedTimeoutInMinutes *int64 `locationName:"queuedTimeoutInMinutes" min:"5" type:"integer"`

	// An array of ProjectArtifacts objects.
	SecondaryArtifacts []ProjectArtifacts `locationName:"secondaryArtifacts" type:"list"`

	// An array of ProjectSource objects.
	SecondarySources []ProjectSource `locationName:"secondarySources" type:"list"`

	// The ARN of the AWS Identity and Access Management (IAM) role that enables
	// AWS CodeBuild to interact with dependent AWS services on behalf of the AWS
	// account.
	ServiceRole *string `locationName:"serviceRole" min:"1" type:"string"`

	// Information about the build input source code for this build project.
	Source *ProjectSource `locationName:"source" type:"structure"`

	// The tags for this build project.
	//
	// These tags are available for use by AWS services that support AWS CodeBuild
	// build project tags.
	Tags []Tag `locationName:"tags" type:"list"`

	// How long, in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait
	// before timing out any related build that did not get marked as completed.
	// The default is 60 minutes.
	TimeoutInMinutes *int64 `locationName:"timeoutInMinutes" min:"5" type:"integer"`

	// Information about the VPC configuration that AWS CodeBuild accesses.
	VpcConfig *VpcConfig `locationName:"vpcConfig" type:"structure"`

	// Information about a webhook that connects repository events to a build project
	// in AWS CodeBuild.
	Webhook *Webhook `locationName:"webhook" type:"structure"`
}

// String returns the string representation
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// Information about the build output artifacts for the build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectArtifacts
type ProjectArtifacts struct {
	_ struct{} `type:"structure"`

	// An identifier for this artifact definition.
	ArtifactIdentifier *string `locationName:"artifactIdentifier" type:"string"`

	// Set to true if you do not want your output artifacts encrypted. This option
	// is valid only if your artifacts type is Amazon Simple Storage Service (Amazon
	// S3). If this is set with another artifacts type, an invalidInputException
	// is thrown.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// Information about the build output artifact location:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    locations instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the name of the output bucket.
	Location *string `locationName:"location" type:"string"`

	// Along with path and namespaceType, the pattern that AWS CodeBuild uses to
	// name and store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the name of the output artifact object.
	//    If you set the name to be a forward slash ("/"), the artifact is stored
	//    in the root of the output bucket.
	//
	// For example:
	//
	//    * If path is set to MyArtifacts, namespaceType is set to BUILD_ID, and
	//    name is set to MyArtifact.zip, then the output artifact is stored in MyArtifacts/build-ID/MyArtifact.zip.
	//
	//    * If path is empty, namespaceType is set to NONE, and name is set to "/",
	//    the output artifact is stored in the root of the output bucket.
	//
	//    * If path is set to MyArtifacts, namespaceType is set to BUILD_ID, and
	//    name is set to "/", the output artifact is stored in MyArtifacts/build-ID .
	Name *string `locationName:"name" type:"string"`

	// Along with path and name, the pattern that AWS CodeBuild uses to determine
	// the name and location to store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, valid values include: BUILD_ID: Include the build
	//    ID in the location of the build output artifact. NONE: Do not include
	//    the build ID. This is the default if namespaceType is not specified.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to BUILD_ID,
	// and name is set to MyArtifact.zip, the output artifact is stored in MyArtifacts/build-ID/MyArtifact.zip.
	NamespaceType ArtifactNamespace `locationName:"namespaceType" type:"string" enum:"true"`

	// If this flag is set, a name specified in the build spec file overrides the
	// artifact name. The name specified in a build spec file is calculated at build
	// time and uses the Shell Command Language. For example, you can append a date
	// and time to your artifact name so that it is always unique.
	OverrideArtifactName *bool `locationName:"overrideArtifactName" type:"boolean"`

	// The type of build output artifact to create:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    artifacts instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, valid values include: NONE: AWS CodeBuild creates
	//    in the output bucket a folder that contains the build output. This is
	//    the default if packaging is not specified. ZIP: AWS CodeBuild creates
	//    in the output bucket a ZIP file that contains the build output.
	Packaging ArtifactPackaging `locationName:"packaging" type:"string" enum:"true"`

	// Along with namespaceType and name, the pattern that AWS CodeBuild uses to
	// name and store the output artifact:
	//
	//    * If type is set to CODEPIPELINE, AWS CodePipeline ignores this value
	//    if specified. This is because AWS CodePipeline manages its build output
	//    names instead of AWS CodeBuild.
	//
	//    * If type is set to NO_ARTIFACTS, this value is ignored if specified,
	//    because no build output is produced.
	//
	//    * If type is set to S3, this is the path to the output artifact. If path
	//    is not specified, path is not used.
	//
	// For example, if path is set to MyArtifacts, namespaceType is set to NONE,
	// and name is set to MyArtifact.zip, the output artifact is stored in the output
	// bucket at MyArtifacts/MyArtifact.zip.
	Path *string `locationName:"path" type:"string"`

	// The type of build output artifact. Valid values include:
	//
	//    * CODEPIPELINE: The build project has build output generated through AWS
	//    CodePipeline.
	//
	//    * NO_ARTIFACTS: The build project does not produce any build output.
	//
	//    * S3: The build project stores build output in Amazon Simple Storage Service
	//    (Amazon S3).
	//
	// Type is a required field
	Type ArtifactsType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProjectArtifacts) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectArtifacts) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectArtifacts"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the build badge for the build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectBadge
type ProjectBadge struct {
	_ struct{} `type:"structure"`

	// Set this to true to generate a publicly accessible URL for your project's
	// build badge.
	BadgeEnabled *bool `locationName:"badgeEnabled" type:"boolean"`

	// The publicly-accessible URL through which you can access the build badge
	// for your project.
	//
	// The publicly accessible URL through which you can access the build badge
	// for your project.
	BadgeRequestUrl *string `locationName:"badgeRequestUrl" type:"string"`
}

// String returns the string representation
func (s ProjectBadge) String() string {
	return awsutil.Prettify(s)
}

// Information about the cache for the build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectCache
type ProjectCache struct {
	_ struct{} `type:"structure"`

	// Information about the cache location:
	//
	//    * NO_CACHE or LOCAL: This value is ignored.
	//
	//    * S3: This is the S3 bucket name/prefix.
	Location *string `locationName:"location" type:"string"`

	// If you use a LOCAL cache, the local cache mode. You can use one or more local
	// cache modes at the same time.
	//
	//    * LOCAL_SOURCE_CACHE mode caches Git metadata for primary and secondary
	//    sources. After the cache is created, subsequent builds pull only the change
	//    between commits. This mode is a good choice for projects with a clean
	//    working directory and a source that is a large Git repository. If you
	//    choose this option and your project does not use a Git repository (GitHub,
	//    GitHub Enterprise, or Bitbucket), the option is ignored.
	//
	//    * LOCAL_DOCKER_LAYER_CACHE mode caches existing Docker layers. This mode
	//    is a good choice for projects that build or pull large Docker images.
	//    It can prevent the performance issues caused by pulling large Docker images
	//    down from the network. You can use a Docker layer cache in the Linux enviornment
	//    only. The privileged flag must be set so that your project has the required
	//    Docker permissions. You should consider the security implications before
	//    you use a Docker layer cache.
	//
	//    * LOCAL_CUSTOM_CACHE mode caches directories you specify in the buildspec
	//    file. This mode is a good choice if your build scenario is not suited
	//    to one of the other three local cache modes. If you use a custom cache:
	//    Only directories can be specified for caching. You cannot specify individual
	//    files. Symlinks are used to reference cached directories. Cached directories
	//    are linked to your build before it downloads its project sources. Cached
	//    items are overriden if a source item has the same name. Directories are
	//    specified using cache paths in the buildspec file.
	Modes []CacheMode `locationName:"modes" type:"list"`

	// The type of cache used by the build project. Valid values include:
	//
	//    * NO_CACHE: The build project does not use any cache.
	//
	//    * S3: The build project reads and writes from and to S3.
	//
	//    * LOCAL: The build project stores a cache locally on a build host that
	//    is only available to that build host.
	//
	// Type is a required field
	Type CacheType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProjectCache) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectCache) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectCache"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the build environment of the build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectEnvironment
type ProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// The certificate to use with this build project.
	Certificate *string `locationName:"certificate" type:"string"`

	// Information about the compute resources the build project uses. Available
	// values include:
	//
	//    * BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds.
	//
	//    * BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds.
	//
	//    * BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds.
	//
	// ComputeType is a required field
	ComputeType ComputeType `locationName:"computeType" type:"string" required:"true" enum:"true"`

	// A set of environment variables to make available to builds for this build
	// project.
	EnvironmentVariables []EnvironmentVariable `locationName:"environmentVariables" type:"list"`

	// The image tag or image digest that identifies the Docker image to use for
	// this build project. Use the following formats:
	//
	//    * For an image tag: registry/repository:tag. For example, to specify an
	//    image with the tag "latest," use registry/repository:latest.
	//
	//    * For an image digest: registry/repository@digest. For example, to specify
	//    an image with the digest "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf,"
	//    use registry/repository@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf.
	//
	// Image is a required field
	Image *string `locationName:"image" min:"1" type:"string" required:"true"`

	// The type of credentials AWS CodeBuild uses to pull images in your build.
	// There are two valid values:
	//
	//    * CODEBUILD specifies that AWS CodeBuild uses its own credentials. This
	//    requires that you modify your ECR repository policy to trust AWS CodeBuild's
	//    service principal.
	//
	//    * SERVICE_ROLE specifies that AWS CodeBuild uses your build project's
	//    service role.
	//
	// When you use a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When you use an AWS CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsType ImagePullCredentialsType `locationName:"imagePullCredentialsType" type:"string" enum:"true"`

	// Enables running the Docker daemon inside a Docker container. Set to true
	// only if the build project is be used to build Docker images, and the specified
	// build environment image is not provided by AWS CodeBuild with Docker support.
	// Otherwise, all associated builds that attempt to interact with the Docker
	// daemon fail. You must also start the Docker daemon so that builds can interact
	// with it. One way to do this is to initialize the Docker daemon during the
	// install phase of your build spec by running the following build commands.
	// (Do not run these commands if the specified build environment image is provided
	// by AWS CodeBuild with Docker support.)
	//
	// If the operating system's base image is Ubuntu Linux:
	//
	// - nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375
	// --storage-driver=overlay& - timeout 15 sh -c "until docker info; do echo
	// .; sleep 1; done"
	//
	// If the operating system's base image is Alpine Linux, add the -t argument
	// to timeout:
	//
	// - nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375
	// --storage-driver=overlay& - timeout 15 -t sh -c "until docker info; do echo
	// .; sleep 1; done"
	PrivilegedMode *bool `locationName:"privilegedMode" type:"boolean"`

	// The credentials for access to a private registry.
	RegistryCredential *RegistryCredential `locationName:"registryCredential" type:"structure"`

	// The type of build environment to use for related builds.
	//
	// Type is a required field
	Type EnvironmentType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectEnvironment) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectEnvironment"}
	if len(s.ComputeType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ComputeType"))
	}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}
	if s.Image != nil && len(*s.Image) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Image", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.EnvironmentVariables != nil {
		for i, v := range s.EnvironmentVariables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentVariables", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RegistryCredential != nil {
		if err := s.RegistryCredential.Validate(); err != nil {
			invalidParams.AddNested("RegistryCredential", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the build input source code for the build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectSource
type ProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the authorization settings for AWS CodeBuild to access
	// the source code to be built.
	//
	// This information is for the AWS CodeBuild console's use only. Your code should
	// not get or set this information directly.
	Auth *SourceAuth `locationName:"auth" type:"structure"`

	// The build spec declaration to use for the builds in this build project.
	//
	// If this value is not specified, a build spec must be included along with
	// the source code to be built.
	Buildspec *string `locationName:"buildspec" type:"string"`

	// Information about the Git clone depth for the build project.
	GitCloneDepth *int64 `locationName:"gitCloneDepth" type:"integer"`

	// Information about the Git submodules configuration for the build project.
	GitSubmodulesConfig *GitSubmodulesConfig `locationName:"gitSubmodulesConfig" type:"structure"`

	// Enable this flag to ignore SSL warnings while connecting to the project source
	// code.
	InsecureSsl *bool `locationName:"insecureSsl" type:"boolean"`

	// Information about the location of the source code to be built. Valid values
	// include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in AWS CodePipeline, location should not be specified. If it
	//    is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline
	//    uses the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an AWS CodeCommit repository, the HTTPS clone URL
	//    to the repository that contains the source code and the build spec (for
	//    example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name
	//    ).
	//
	//    * For source code in an Amazon Simple Storage Service (Amazon S3) input
	//    bucket, one of the following. The path to the ZIP file that contains the
	//    source code (for example, bucket-name/path/to/object-name.zip). The path
	//    to the folder that contains the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the build spec. You must connect your AWS
	//    account to your GitHub account. Use the AWS CodeBuild console to start
	//    creating a build project. When you use the console to connect (or reconnect)
	//    with GitHub, on the GitHub Authorize application page, for Organization
	//    access, choose Request access next to each repository you want to allow
	//    AWS CodeBuild to have access to, and then choose Authorize application.
	//    (After you have connected to your GitHub account, you do not need to finish
	//    creating the build project. You can leave the AWS CodeBuild console.)
	//    To instruct AWS CodeBuild to use this connection, in the source object,
	//    set the auth object's type value to OAUTH.
	//
	//    * For source code in a Bitbucket repository, the HTTPS clone URL to the
	//    repository that contains the source and the build spec. You must connect
	//    your AWS account to your Bitbucket account. Use the AWS CodeBuild console
	//    to start creating a build project. When you use the console to connect
	//    (or reconnect) with Bitbucket, on the Bitbucket Confirm access to your
	//    account page, choose Grant access. (After you have connected to your Bitbucket
	//    account, you do not need to finish creating the build project. You can
	//    leave the AWS CodeBuild console.) To instruct AWS CodeBuild to use this
	//    connection, in the source object, set the auth object's type value to
	//    OAUTH.
	Location *string `locationName:"location" type:"string"`

	// Set to true to report the status of a build's start and finish to your source
	// provider. This option is valid only when your source provider is GitHub,
	// GitHub Enterprise, or Bitbucket. If this is set and you use a different source
	// provider, an invalidInputException is thrown.
	ReportBuildStatus *bool `locationName:"reportBuildStatus" type:"boolean"`

	// An identifier for this project source.
	SourceIdentifier *string `locationName:"sourceIdentifier" type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// include:
	//
	//    * BITBUCKET: The source code is in a Bitbucket repository.
	//
	//    * CODECOMMIT: The source code is in an AWS CodeCommit repository.
	//
	//    * CODEPIPELINE: The source code settings are specified in the source action
	//    of a pipeline in AWS CodePipeline.
	//
	//    * GITHUB: The source code is in a GitHub repository.
	//
	//    * NO_SOURCE: The project does not have input source code.
	//
	//    * S3: The source code is in an Amazon Simple Storage Service (Amazon S3)
	//    input bucket.
	//
	// Type is a required field
	Type SourceType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ProjectSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectSource"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Auth != nil {
		if err := s.Auth.Validate(); err != nil {
			invalidParams.AddNested("Auth", err.(aws.ErrInvalidParams))
		}
	}
	if s.GitSubmodulesConfig != nil {
		if err := s.GitSubmodulesConfig.Validate(); err != nil {
			invalidParams.AddNested("GitSubmodulesConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A source identifier and its corresponding version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ProjectSourceVersion
type ProjectSourceVersion struct {
	_ struct{} `type:"structure"`

	// An identifier for a source in the build project.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `locationName:"sourceIdentifier" type:"string" required:"true"`

	// The source version for the corresponding source identifier. If specified,
	// must be one of:
	//
	//    * For AWS CodeCommit: the commit ID to use.
	//
	//    * For GitHub: the commit ID, pull request ID, branch name, or tag name
	//    that corresponds to the version of the source code you want to build.
	//    If a pull request ID is specified, it must use the format pr/pull-request-ID
	//    (for example, pr/25). If a branch name is specified, the branch's HEAD
	//    commit ID is used. If not specified, the default branch's HEAD commit
	//    ID is used.
	//
	//    * For Bitbucket: the commit ID, branch name, or tag name that corresponds
	//    to the version of the source code you want to build. If a branch name
	//    is specified, the branch's HEAD commit ID is used. If not specified, the
	//    default branch's HEAD commit ID is used.
	//
	//    * For Amazon Simple Storage Service (Amazon S3): the version ID of the
	//    object that represents the build input ZIP file to use.
	//
	// SourceVersion is a required field
	SourceVersion *string `locationName:"sourceVersion" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectSourceVersion) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProjectSourceVersion) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ProjectSourceVersion"}

	if s.SourceIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceIdentifier"))
	}

	if s.SourceVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about credentials that provide access to a private Docker registry.
// When this is set:
//
//    * imagePullCredentialsType must be set to SERVICE_ROLE.
//
//    * images cannot be curated or an Amazon ECR image.
//
// For more information, see Private Registry with AWS Secrets Manager Sample
// for AWS CodeBuild (https://docs.aws.amazon.com/codebuild/latest/userguide/sample-private-registry.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/RegistryCredential
type RegistryCredential struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets
	// Manager.
	//
	// The credential can use the name of the credentials only if they exist in
	// your current region.
	//
	// Credential is a required field
	Credential *string `locationName:"credential" min:"1" type:"string" required:"true"`

	// The service that created the credentials to access a private Docker registry.
	// The valid value, SECRETS_MANAGER, is for AWS Secrets Manager.
	//
	// CredentialProvider is a required field
	CredentialProvider CredentialProviderType `locationName:"credentialProvider" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RegistryCredential) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegistryCredential) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegistryCredential"}

	if s.Credential == nil {
		invalidParams.Add(aws.NewErrParamRequired("Credential"))
	}
	if s.Credential != nil && len(*s.Credential) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Credential", 1))
	}
	if len(s.CredentialProvider) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("CredentialProvider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about S3 logs for a build project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/S3LogsConfig
type S3LogsConfig struct {
	_ struct{} `type:"structure"`

	// Set to true if you do not want your S3 build log output encrypted. By default
	// S3 build logs are encrypted.
	EncryptionDisabled *bool `locationName:"encryptionDisabled" type:"boolean"`

	// The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3
	// bucket name is my-bucket, and your path prefix is build-log, then acceptable
	// formats are my-bucket/build-log or arn:aws:s3:::my-bucket/build-log.
	Location *string `locationName:"location" type:"string"`

	// The current status of the S3 build logs. Valid values are:
	//
	//    * ENABLED: S3 build logs are enabled for this build project.
	//
	//    * DISABLED: S3 build logs are not enabled for this build project.
	//
	// Status is a required field
	Status LogsConfigStatusType `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s S3LogsConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3LogsConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3LogsConfig"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the authorization settings for AWS CodeBuild to access
// the source code to be built.
//
// This information is for the AWS CodeBuild console's use only. Your code should
// not get or set this information directly.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/SourceAuth
type SourceAuth struct {
	_ struct{} `type:"structure"`

	// The resource value that applies to the specified authorization type.
	Resource *string `locationName:"resource" type:"string"`

	//
	// This data type is deprecated and is no longer accurate or used.
	//
	// The authorization type to use. The only valid value is OAUTH, which represents
	// the OAuth authorization type.
	//
	// Type is a required field
	Type SourceAuthType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SourceAuth) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceAuth) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceAuth"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the credentials for a GitHub, GitHub Enterprise, or Bitbucket
// repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/SourceCredentialsInfo
type SourceCredentialsInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the token.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The type of authentication used by the credentials. Valid options are OAUTH,
	// BASIC_AUTH, or PERSONAL_ACCESS_TOKEN.
	AuthType AuthType `locationName:"authType" type:"string" enum:"true"`

	// The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE,
	// or BITBUCKET.
	ServerType ServerType `locationName:"serverType" type:"string" enum:"true"`
}

// String returns the string representation
func (s SourceCredentialsInfo) String() string {
	return awsutil.Prettify(s)
}

// A tag, consisting of a key and a value.
//
// This tag is available for use by AWS services that support tags in AWS CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The tag's value.
	Value *string `locationName:"value" min:"1" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the VPC configuration that AWS CodeBuild accesses.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/VpcConfig
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security groups IDs in your Amazon VPC.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// A list of one or more subnet IDs in your Amazon VPC.
	Subnets []string `locationName:"subnets" type:"list"`

	// The ID of the Amazon VPC.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VpcConfig"}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a webhook that connects repository events to a build project
// in AWS CodeBuild.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/Webhook
type Webhook struct {
	_ struct{} `type:"structure"`

	// A regular expression used to determine which repository branches are built
	// when a webhook is triggered. If the name of a branch matches the regular
	// expression, then it is built. If branchFilter is empty, then all branches
	// are built.
	//
	// It is recommended that you use filterGroups instead of branchFilter.
	BranchFilter *string `locationName:"branchFilter" type:"string"`

	// An array of arrays of WebhookFilter objects used to determine which webhooks
	// are triggered. At least one WebhookFilter in the array must specify EVENT
	// as its type.
	//
	// For a build to be triggered, at least one filter group in the filterGroups
	// array must pass. For a filter group to pass, each of its filters must pass.
	FilterGroups [][]WebhookFilter `locationName:"filterGroups" type:"list"`

	// A timestamp that indicates the last time a repository's secret token was
	// modified.
	LastModifiedSecret *time.Time `locationName:"lastModifiedSecret" type:"timestamp" timestampFormat:"unix"`

	// The AWS CodeBuild endpoint where webhook events are sent.
	PayloadUrl *string `locationName:"payloadUrl" min:"1" type:"string"`

	// The secret token of the associated repository.
	//
	// A Bitbucket webhook does not support secret.
	Secret *string `locationName:"secret" min:"1" type:"string"`

	// The URL to the webhook.
	Url *string `locationName:"url" min:"1" type:"string"`
}

// String returns the string representation
func (s Webhook) String() string {
	return awsutil.Prettify(s)
}

// A filter used to determine which webhooks trigger a build.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/WebhookFilter
type WebhookFilter struct {
	_ struct{} `type:"structure"`

	// Used to indicate that the pattern determines which webhook events do not
	// trigger a build. If true, then a webhook event that does not match the pattern
	// triggers a build. If false, then a webhook event that matches the pattern
	// triggers a build.
	ExcludeMatchedPattern *bool `locationName:"excludeMatchedPattern" type:"boolean"`

	// For a WebHookFilter that uses EVENT type, a comma-separated string that specifies
	// one or more events. For example, the webhook filter PUSH, PULL_REQUEST_CREATED,
	// PULL_REQUEST_UPDATED allows all push, pull request created, and pull request
	// updated events to trigger a build.
	//
	// For a WebHookFilter that uses any of the other filter types, a regular expression
	// pattern. For example, a WebHookFilter that uses HEAD_REF for its type and
	// the pattern ^refs/heads/ triggers a build when the head reference is a branch
	// with a reference name refs/heads/branch-name.
	//
	// Pattern is a required field
	Pattern *string `locationName:"pattern" type:"string" required:"true"`

	// The type of webhook filter. There are five webhook filter types: EVENT, ACTOR_ACCOUNT_ID,
	// HEAD_REF, BASE_REF, and FILE_PATH.
	//
	// EVENT
	//
	// A webhook event triggers a build when the provided pattern matches one of
	// four event types: PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED, and PULL_REQUEST_REOPENED.
	// The EVENT patterns are specified as a comma-separated string. For example,
	// PUSH, PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED filters all push, pull request
	// created, and pull request updated events.
	//
	// The PULL_REQUEST_REOPENED works with GitHub and GitHub Enterprise only.
	//
	// ACTOR_ACCOUNT_ID
	//
	// A webhook event triggers a build when a GitHub, GitHub Enterprise, or Bitbucket
	// account ID matches the regular expression pattern.
	//
	// HEAD_REF
	//
	// A webhook event triggers a build when the head reference matches the regular
	// expression pattern. For example, refs/heads/branch-name and refs/tags/tag-name.
	//
	// Works with GitHub and GitHub Enterprise push, GitHub and GitHub Enterprise
	// pull request, Bitbucket push, and Bitbucket pull request events.
	//
	// BASE_REF
	//
	// A webhook event triggers a build when the base reference matches the regular
	// expression pattern. For example, refs/heads/branch-name.
	//
	// Works with pull request events only.
	//
	// FILE_PATH
	//
	// A webhook triggers a build when the path of a changed file matches the regular
	// expression pattern.
	//
	// Works with GitHub and GitHub Enterprise push events only.
	//
	// Type is a required field
	Type WebhookFilterType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s WebhookFilter) String() string {
	return awsutil.Prettify(s)
}
