// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchlogs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKeyRequest
type AssociateKmsKeyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.
	// For more information, see Amazon Resource Names - AWS Key Management Service
	// (AWS KMS) (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms).
	//
	// KmsKeyId is a required field
	KmsKeyId *string `locationName:"kmsKeyId" type:"string" required:"true"`

	// The name of the log group.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateKmsKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateKmsKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateKmsKeyInput"}

	if s.KmsKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KmsKeyId"))
	}

	if s.LogGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKeyOutput
type AssociateKmsKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateKmsKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateKmsKey = "AssociateKmsKey"

// AssociateKmsKeyRequest returns a request value for making API operation for
// Amazon CloudWatch Logs.
//
// Associates the specified AWS Key Management Service (AWS KMS) customer master
// key (CMK) with the specified log group.
//
// Associating an AWS KMS CMK with a log group overrides any existing associations
// between the log group and a CMK. After a CMK is associated with a log group,
// all newly ingested data for the log group is encrypted using the CMK. This
// association is stored as long as the data encrypted with the CMK is still
// within Amazon CloudWatch Logs. This enables Amazon CloudWatch Logs to decrypt
// this data whenever it is requested.
//
// Note that it can take up to 5 minutes for this operation to take effect.
//
// If you attempt to associate a CMK with a log group but the CMK does not exist
// or the CMK is disabled, you will receive an InvalidParameterException error.
//
//    // Example sending a request using AssociateKmsKeyRequest.
//    req := client.AssociateKmsKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKey
func (c *Client) AssociateKmsKeyRequest(input *AssociateKmsKeyInput) AssociateKmsKeyRequest {
	op := &aws.Operation{
		Name:       opAssociateKmsKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateKmsKeyInput{}
	}

	req := c.newRequest(op, input, &AssociateKmsKeyOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AssociateKmsKeyRequest{Request: req, Input: input, Copy: c.AssociateKmsKeyRequest}
}

// AssociateKmsKeyRequest is the request type for the
// AssociateKmsKey API operation.
type AssociateKmsKeyRequest struct {
	*aws.Request
	Input *AssociateKmsKeyInput
	Copy  func(*AssociateKmsKeyInput) AssociateKmsKeyRequest
}

// Send marshals and sends the AssociateKmsKey API request.
func (r AssociateKmsKeyRequest) Send(ctx context.Context) (*AssociateKmsKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateKmsKeyResponse{
		AssociateKmsKeyOutput: r.Request.Data.(*AssociateKmsKeyOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateKmsKeyResponse is the response type for the
// AssociateKmsKey API operation.
type AssociateKmsKeyResponse struct {
	*AssociateKmsKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateKmsKey request.
func (r *AssociateKmsKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
