// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Represents the history of a specific alarm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/AlarmHistoryItem
type AlarmHistoryItem struct {
	_ struct{} `type:"structure"`

	// The descriptive name for the alarm.
	AlarmName *string `min:"1" type:"string"`

	// Data about the alarm, in JSON format.
	HistoryData *string `min:"1" type:"string"`

	// The type of alarm history item.
	HistoryItemType HistoryItemType `type:"string" enum:"true"`

	// A summary of the alarm history, in text format.
	HistorySummary *string `min:"1" type:"string"`

	// The time stamp for the alarm history item.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s AlarmHistoryItem) String() string {
	return awsutil.Prettify(s)
}

// Represents a specific dashboard.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DashboardEntry
type DashboardEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The name of the dashboard.
	DashboardName *string `type:"string"`

	// The time stamp of when the dashboard was last modified, either by an API
	// call or through the console. This number is expressed as the number of milliseconds
	// since Jan 1, 1970 00:00:00 UTC.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The size of the dashboard, in bytes.
	Size *int64 `type:"long"`
}

// String returns the string representation
func (s DashboardEntry) String() string {
	return awsutil.Prettify(s)
}

// An error or warning for the operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DashboardValidationMessage
type DashboardValidationMessage struct {
	_ struct{} `type:"structure"`

	// The data path related to the message.
	DataPath *string `type:"string"`

	// A message describing the error or warning.
	Message *string `type:"string"`
}

// String returns the string representation
func (s DashboardValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// Encapsulates the statistical data that CloudWatch computes from metric data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/Datapoint
type Datapoint struct {
	_ struct{} `type:"structure"`

	// The average of the metric values that correspond to the data point.
	Average *float64 `type:"double"`

	// The percentile statistic for the data point.
	ExtendedStatistics map[string]float64 `type:"map"`

	// The maximum metric value for the data point.
	Maximum *float64 `type:"double"`

	// The minimum metric value for the data point.
	Minimum *float64 `type:"double"`

	// The number of metric values that contributed to the aggregate value of this
	// data point.
	SampleCount *float64 `type:"double"`

	// The sum of the metric values for the data point.
	Sum *float64 `type:"double"`

	// The time stamp used for the data point.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The standard unit for the data point.
	Unit StandardUnit `type:"string" enum:"true"`
}

// String returns the string representation
func (s Datapoint) String() string {
	return awsutil.Prettify(s)
}

// Expands the identity of a metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/Dimension
type Dimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value representing the dimension measurement.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dimension) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Dimension"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents filters for a dimension.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DimensionFilter
type DimensionFilter struct {
	_ struct{} `type:"structure"`

	// The dimension name to be matched.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the dimension to be matched.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DimensionFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DimensionFilter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A message returned by the GetMetricDataAPI, including a code and a description.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MessageData
type MessageData struct {
	_ struct{} `type:"structure"`

	// The error code or status code associated with the message.
	Code *string `type:"string"`

	// The message text.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MessageData) String() string {
	return awsutil.Prettify(s)
}

// Represents a specific metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/Metric
type Metric struct {
	_ struct{} `type:"structure"`

	// The dimensions for the metric.
	Dimensions []Dimension `type:"list"`

	// The name of the metric. This is a required field.
	MetricName *string `min:"1" type:"string"`

	// The namespace of the metric.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Metric) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metric) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Metric"}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MetricName", 1))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Namespace", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents an alarm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MetricAlarm
type MetricAlarm struct {
	_ struct{} `type:"structure"`

	// Indicates whether actions should be executed during any changes to the alarm
	// state.
	ActionsEnabled *bool `type:"boolean"`

	// The actions to execute when this alarm transitions to the ALARM state from
	// any other state. Each action is specified as an Amazon Resource Name (ARN).
	AlarmActions []string `type:"list"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmArn *string `min:"1" type:"string"`

	// The time stamp of the last update to the alarm configuration.
	AlarmConfigurationUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of the alarm.
	AlarmDescription *string `type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`

	// The arithmetic operation to use when comparing the specified statistic and
	// threshold. The specified statistic value is used as the first operand.
	ComparisonOperator ComparisonOperator `type:"string" enum:"true"`

	// The number of datapoints that must be breaching to trigger the alarm.
	DatapointsToAlarm *int64 `min:"1" type:"integer"`

	// The dimensions for the metric associated with the alarm.
	Dimensions []Dimension `type:"list"`

	// Used only for alarms based on percentiles. If ignore, the alarm state does
	// not change during periods with too few data points to be statistically significant.
	// If evaluate or this parameter is not used, the alarm is always evaluated
	// and possibly changes state no matter how many data points are available.
	EvaluateLowSampleCountPercentile *string `min:"1" type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// The percentile statistic for the metric associated with the alarm. Specify
	// a value between p0.0 and p100.
	ExtendedStatistic *string `type:"string"`

	// The actions to execute when this alarm transitions to the INSUFFICIENT_DATA
	// state from any other state. Each action is specified as an Amazon Resource
	// Name (ARN).
	InsufficientDataActions []string `type:"list"`

	// The name of the metric associated with the alarm.
	MetricName *string `min:"1" type:"string"`

	Metrics []MetricDataQuery `type:"list"`

	// The namespace of the metric associated with the alarm.
	Namespace *string `min:"1" type:"string"`

	// The actions to execute when this alarm transitions to the OK state from any
	// other state. Each action is specified as an Amazon Resource Name (ARN).
	OKActions []string `type:"list"`

	// The period, in seconds, over which the statistic is applied.
	Period *int64 `min:"1" type:"integer"`

	// An explanation for the alarm state, in text format.
	StateReason *string `type:"string"`

	// An explanation for the alarm state, in JSON format.
	StateReasonData *string `type:"string"`

	// The time stamp of the last update to the alarm state.
	StateUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state value for the alarm.
	StateValue StateValue `type:"string" enum:"true"`

	// The statistic for the metric associated with the alarm, other than percentile.
	// For percentile statistics, use ExtendedStatistic.
	Statistic Statistic `type:"string" enum:"true"`

	// The value to compare with the specified statistic.
	Threshold *float64 `type:"double"`

	// Sets how this alarm is to handle missing data points. If this parameter is
	// omitted, the default behavior of missing is used.
	TreatMissingData *string `min:"1" type:"string"`

	// The unit of the metric associated with the alarm.
	Unit StandardUnit `type:"string" enum:"true"`
}

// String returns the string representation
func (s MetricAlarm) String() string {
	return awsutil.Prettify(s)
}

// This structure is used in both GetMetricData and PutMetricAlarm. The supported
// use of this structure is different for those two operations.
//
// When used in GetMetricData, it indicates the metric data to return, and whether
// this call is just retrieving a batch set of data for one metric, or is performing
// a math expression on metric data. A single GetMetricData call can include
// up to 100 MetricDataQuery structures.
//
// When used in PutMetricAlarm, it enables you to create an alarm based on a
// metric math expression. Each MetricDataQuery in the array specifies either
// a metric to retrieve, or a math expression to be performed on retrieved metrics.
// A single PutMetricAlarm call can include up to 20 MetricDataQuery structures
// in the array. The 20 structures can include as many as 10 structures that
// contain a MetricStat parameter to retrieve a metric, and as many as 10 structures
// that contain the Expression parameter to perform a math expression. Of those
// Expression structures, one must have True as the value for ReturnData. The
// result of this expression is the value the alarm watches.
//
// Any expression used in a PutMetricAlarm operation must return a single time
// series. For more information, see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
// in the Amazon CloudWatch User Guide.
//
// Some of the parameters of this structure also have different uses whether
// you are using this structure in a GetMetricData operation or a PutMetricAlarm
// operation. These differences are explained in the following parameter list.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MetricDataQuery
type MetricDataQuery struct {
	_ struct{} `type:"structure"`

	// The math expression to be performed on the returned data, if this object
	// is performing a math expression. This expression can use the Id of the other
	// metrics to refer to those metrics, and can also use the Id of other expressions
	// to use the result of those expressions. For more information about metric
	// math expressions, see Metric Math Syntax and Functions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax)
	// in the Amazon CloudWatch User Guide.
	//
	// Within each MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	Expression *string `min:"1" type:"string"`

	// A short name used to tie this object to the results in the response. This
	// name must be unique within a single call to GetMetricData. If you are performing
	// math expressions on this set of data, this name represents that data and
	// can serve as a variable in the mathematical expression. The valid characters
	// are letters, numbers, and underscore. The first character must be a lowercase
	// letter.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A human-readable label for this metric or expression. This is especially
	// useful if this is an expression, so that you know what the value represents.
	// If the metric or expression is shown in a CloudWatch dashboard widget, the
	// label is shown. If Label is omitted, CloudWatch generates a default.
	Label *string `type:"string"`

	// The metric to be returned, along with statistics, period, and units. Use
	// this parameter only if this object is retrieving a metric and not performing
	// a math expression on returned data.
	//
	// Within one MetricDataQuery object, you must specify either Expression or
	// MetricStat but not both.
	MetricStat *MetricStat `type:"structure"`

	// When used in GetMetricData, this option indicates whether to return the timestamps
	// and raw data values of this metric. If you are performing this call just
	// to do math expressions and do not also need the raw data returned, you can
	// specify False. If you omit this, the default of True is used.
	//
	// When used in PutMetricAlarm, specify True for the one expression result to
	// use as the alarm. For all other metrics and expressions in the same PutMetricAlarm
	// operation, specify ReturnData as False.
	ReturnData *bool `type:"boolean"`
}

// String returns the string representation
func (s MetricDataQuery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDataQuery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricDataQuery"}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Expression", 1))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}
	if s.MetricStat != nil {
		if err := s.MetricStat.Validate(); err != nil {
			invalidParams.AddNested("MetricStat", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A GetMetricData call returns an array of MetricDataResult structures. Each
// of these structures includes the data points for that metric, along with
// the timestamps of those data points and other identifying information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MetricDataResult
type MetricDataResult struct {
	_ struct{} `type:"structure"`

	// The short name you specified to represent this metric.
	Id *string `min:"1" type:"string"`

	// The human-readable label associated with the data.
	Label *string `type:"string"`

	// A list of messages with additional information about the data returned.
	Messages []MessageData `type:"list"`

	// The status of the returned data. Complete indicates that all data points
	// in the requested time range were returned. PartialData means that an incomplete
	// set of data points were returned. You can use the NextToken value that was
	// returned and repeat your request to get more data points. NextToken is not
	// returned if you are performing a math expression. InternalError indicates
	// that an error occurred. Retry your request using NextToken, if present.
	StatusCode StatusCode `type:"string" enum:"true"`

	// The timestamps for the data points, formatted in Unix timestamp format. The
	// number of timestamps always matches the number of values and the value for
	// Timestamps[x] is Values[x].
	Timestamps []time.Time `type:"list"`

	// The data points for the metric corresponding to Timestamps. The number of
	// values always matches the number of timestamps and the timestamp for Values[x]
	// is Timestamps[x].
	Values []float64 `type:"list"`
}

// String returns the string representation
func (s MetricDataResult) String() string {
	return awsutil.Prettify(s)
}

// Encapsulates the information sent to either create a metric or add new values
// to be aggregated into an existing metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MetricDatum
type MetricDatum struct {
	_ struct{} `type:"structure"`

	// Array of numbers that is used along with the Values array. Each number in
	// the Count array is the number of times the corresponding value in the Values
	// array occurred during the period.
	//
	// If you omit the Counts array, the default of 1 is used as the value for each
	// count. If you include a Counts array, it must include the same amount of
	// values as the Values array.
	Counts []float64 `type:"list"`

	// The dimensions associated with the metric.
	Dimensions []Dimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The statistical values for the metric.
	StatisticValues *StatisticSet `type:"structure"`

	// Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution
	// metric, so that CloudWatch stores the metric with sub-minute resolution down
	// to one second. Setting this to 60 specifies this metric as a regular-resolution
	// metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution
	// is available only for custom metrics. For more information about high-resolution
	// metrics, see High-Resolution Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics)
	// in the Amazon CloudWatch User Guide.
	//
	// This field is optional, if you do not specify it the default of 60 is used.
	StorageResolution *int64 `min:"1" type:"integer"`

	// The time the metric data was received, expressed as the number of milliseconds
	// since Jan 1, 1970 00:00:00 UTC.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unit of the metric.
	Unit StandardUnit `type:"string" enum:"true"`

	// The value for the metric.
	//
	// Although the parameter accepts numbers of type Double, CloudWatch rejects
	// values that are either too small or too large. Values must be in the range
	// of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
	// In addition, special values (for example, NaN, +Infinity, -Infinity) are
	// not supported.
	Value *float64 `type:"double"`

	// Array of numbers representing the values for the metric during the period.
	// Each unique value is listed just once in this array, and the corresponding
	// number in the Counts array specifies the number of times that value occurred
	// during the period. You can include up to 150 unique values in each PutMetricData
	// action that specifies a Values array.
	//
	// Although the Values array accepts numbers of type Double, CloudWatch rejects
	// values that are either too small or too large. Values must be in the range
	// of 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
	// In addition, special values (for example, NaN, +Infinity, -Infinity) are
	// not supported.
	Values []float64 `type:"list"`
}

// String returns the string representation
func (s MetricDatum) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDatum) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricDatum"}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MetricName", 1))
	}
	if s.StorageResolution != nil && *s.StorageResolution < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("StorageResolution", 1))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.StatisticValues != nil {
		if err := s.StatisticValues.Validate(); err != nil {
			invalidParams.AddNested("StatisticValues", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This structure defines the metric to be returned, along with the statistics,
// period, and units.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MetricStat
type MetricStat struct {
	_ struct{} `type:"structure"`

	// The metric to return, including the metric name, namespace, and dimensions.
	//
	// Metric is a required field
	Metric *Metric `type:"structure" required:"true"`

	// The period, in seconds, to use when retrieving the metric.
	//
	// Period is a required field
	Period *int64 `min:"1" type:"integer" required:"true"`

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic.
	//
	// Stat is a required field
	Stat *string `type:"string" required:"true"`

	// The unit to use for the returned data points.
	Unit StandardUnit `type:"string" enum:"true"`
}

// String returns the string representation
func (s MetricStat) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricStat) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricStat"}

	if s.Metric == nil {
		invalidParams.Add(aws.NewErrParamRequired("Metric"))
	}

	if s.Period == nil {
		invalidParams.Add(aws.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Period", 1))
	}

	if s.Stat == nil {
		invalidParams.Add(aws.NewErrParamRequired("Stat"))
	}
	if s.Metric != nil {
		if err := s.Metric.Validate(); err != nil {
			invalidParams.AddNested("Metric", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a set of statistics that describes a specific metric.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/StatisticSet
type StatisticSet struct {
	_ struct{} `type:"structure"`

	// The maximum value of the sample set.
	//
	// Maximum is a required field
	Maximum *float64 `type:"double" required:"true"`

	// The minimum value of the sample set.
	//
	// Minimum is a required field
	Minimum *float64 `type:"double" required:"true"`

	// The number of samples used for the statistic set.
	//
	// SampleCount is a required field
	SampleCount *float64 `type:"double" required:"true"`

	// The sum of values for the sample set.
	//
	// Sum is a required field
	Sum *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s StatisticSet) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatisticSet) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StatisticSet"}

	if s.Maximum == nil {
		invalidParams.Add(aws.NewErrParamRequired("Maximum"))
	}

	if s.Minimum == nil {
		invalidParams.Add(aws.NewErrParamRequired("Minimum"))
	}

	if s.SampleCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("SampleCount"))
	}

	if s.Sum == nil {
		invalidParams.Add(aws.NewErrParamRequired("Sum"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A key-value pair associated with a CloudWatch resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// A string that you can use to assign a value. The combination of tag keys
	// and values can help you organize and categorize your resources.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the specified tag key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
