// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarmsInput
type DeleteAlarmsInput struct {
	_ struct{} `type:"structure"`

	// The alarms to be deleted.
	//
	// AlarmNames is a required field
	AlarmNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteAlarmsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAlarmsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAlarmsInput"}

	if s.AlarmNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlarmNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarmsOutput
type DeleteAlarmsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAlarmsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAlarms = "DeleteAlarms"

// DeleteAlarmsRequest returns a request value for making API operation for
// Amazon CloudWatch.
//
// Deletes the specified alarms. In the event of an error, no alarms are deleted.
//
//    // Example sending a request using DeleteAlarmsRequest.
//    req := client.DeleteAlarmsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/DeleteAlarms
func (c *Client) DeleteAlarmsRequest(input *DeleteAlarmsInput) DeleteAlarmsRequest {
	op := &aws.Operation{
		Name:       opDeleteAlarms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlarmsInput{}
	}

	req := c.newRequest(op, input, &DeleteAlarmsOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteAlarmsRequest{Request: req, Input: input, Copy: c.DeleteAlarmsRequest}
}

// DeleteAlarmsRequest is the request type for the
// DeleteAlarms API operation.
type DeleteAlarmsRequest struct {
	*aws.Request
	Input *DeleteAlarmsInput
	Copy  func(*DeleteAlarmsInput) DeleteAlarmsRequest
}

// Send marshals and sends the DeleteAlarms API request.
func (r DeleteAlarmsRequest) Send(ctx context.Context) (*DeleteAlarmsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAlarmsResponse{
		DeleteAlarmsOutput: r.Request.Data.(*DeleteAlarmsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAlarmsResponse is the response type for the
// DeleteAlarms API operation.
type DeleteAlarmsResponse struct {
	*DeleteAlarmsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAlarms request.
func (r *DeleteAlarmsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
