// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsmv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteHsmRequest
type DeleteHsmInput struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the cluster that contains the HSM that you are deleting.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The identifier (ID) of the elastic network interface (ENI) of the HSM that
	// you are deleting.
	EniId *string `type:"string"`

	// The IP address of the elastic network interface (ENI) of the HSM that you
	// are deleting.
	EniIp *string `type:"string"`

	// The identifier (ID) of the HSM that you are deleting.
	HsmId *string `type:"string"`
}

// String returns the string representation
func (s DeleteHsmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteHsmInput"}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteHsmResponse
type DeleteHsmOutput struct {
	_ struct{} `type:"structure"`

	// The identifier (ID) of the HSM that was deleted.
	HsmId *string `type:"string"`
}

// String returns the string representation
func (s DeleteHsmOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteHsm = "DeleteHsm"

// DeleteHsmRequest returns a request value for making API operation for
// AWS CloudHSM V2.
//
// Deletes the specified HSM. To specify an HSM, you can use its identifier
// (ID), the IP address of the HSM's elastic network interface (ENI), or the
// ID of the HSM's ENI. You need to specify only one of these values. To find
// these values, use DescribeClusters.
//
//    // Example sending a request using DeleteHsmRequest.
//    req := client.DeleteHsmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/DeleteHsm
func (c *Client) DeleteHsmRequest(input *DeleteHsmInput) DeleteHsmRequest {
	op := &aws.Operation{
		Name:       opDeleteHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmInput{}
	}

	req := c.newRequest(op, input, &DeleteHsmOutput{})
	return DeleteHsmRequest{Request: req, Input: input, Copy: c.DeleteHsmRequest}
}

// DeleteHsmRequest is the request type for the
// DeleteHsm API operation.
type DeleteHsmRequest struct {
	*aws.Request
	Input *DeleteHsmInput
	Copy  func(*DeleteHsmInput) DeleteHsmRequest
}

// Send marshals and sends the DeleteHsm API request.
func (r DeleteHsmRequest) Send(ctx context.Context) (*DeleteHsmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteHsmResponse{
		DeleteHsmOutput: r.Request.Data.(*DeleteHsmOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteHsmResponse is the response type for the
// DeleteHsm API operation.
type DeleteHsmResponse struct {
	*DeleteHsmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteHsm request.
func (r *DeleteHsmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
