// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

// Deletes a origin access identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DeleteCloudFrontOriginAccessIdentityRequest
type DeleteCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `type:"structure"`

	// The origin access identity's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received from a previous GET or PUT request.
	// For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCloudFrontOriginAccessIdentityInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteCloudFrontOriginAccessIdentityInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DeleteCloudFrontOriginAccessIdentityOutput
type DeleteCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteCloudFrontOriginAccessIdentityOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteCloudFrontOriginAccessIdentity = "DeleteCloudFrontOriginAccessIdentity2018_11_05"

// DeleteCloudFrontOriginAccessIdentityRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Delete an origin access identity.
//
//    // Example sending a request using DeleteCloudFrontOriginAccessIdentityRequest.
//    req := client.DeleteCloudFrontOriginAccessIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/DeleteCloudFrontOriginAccessIdentity
func (c *Client) DeleteCloudFrontOriginAccessIdentityRequest(input *DeleteCloudFrontOriginAccessIdentityInput) DeleteCloudFrontOriginAccessIdentityRequest {
	op := &aws.Operation{
		Name:       opDeleteCloudFrontOriginAccessIdentity,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2018-11-05/origin-access-identity/cloudfront/{Id}",
	}

	if input == nil {
		input = &DeleteCloudFrontOriginAccessIdentityInput{}
	}

	req := c.newRequest(op, input, &DeleteCloudFrontOriginAccessIdentityOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteCloudFrontOriginAccessIdentityRequest{Request: req, Input: input, Copy: c.DeleteCloudFrontOriginAccessIdentityRequest}
}

// DeleteCloudFrontOriginAccessIdentityRequest is the request type for the
// DeleteCloudFrontOriginAccessIdentity API operation.
type DeleteCloudFrontOriginAccessIdentityRequest struct {
	*aws.Request
	Input *DeleteCloudFrontOriginAccessIdentityInput
	Copy  func(*DeleteCloudFrontOriginAccessIdentityInput) DeleteCloudFrontOriginAccessIdentityRequest
}

// Send marshals and sends the DeleteCloudFrontOriginAccessIdentity API request.
func (r DeleteCloudFrontOriginAccessIdentityRequest) Send(ctx context.Context) (*DeleteCloudFrontOriginAccessIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCloudFrontOriginAccessIdentityResponse{
		DeleteCloudFrontOriginAccessIdentityOutput: r.Request.Data.(*DeleteCloudFrontOriginAccessIdentityOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCloudFrontOriginAccessIdentityResponse is the response type for the
// DeleteCloudFrontOriginAccessIdentity API operation.
type DeleteCloudFrontOriginAccessIdentityResponse struct {
	*DeleteCloudFrontOriginAccessIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCloudFrontOriginAccessIdentity request.
func (r *DeleteCloudFrontOriginAccessIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
