// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The input for a GetTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateInput
type GetTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation
	// returns the associated template. If you specify a name, you must also specify
	// the StackName.
	ChangeSetName *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`

	// For templates that include transforms, the stage of the template that AWS
	// CloudFormation returns. To get the user-submitted template, specify Original.
	// To get the template after AWS CloudFormation has processed all transforms,
	// specify Processed.
	//
	// If the template doesn't include transforms, Original and Processed return
	// the same template. By default, AWS CloudFormation specifies Original.
	TemplateStage TemplateStage `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for GetTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateOutput
type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The stage of the template that you can retrieve. For stacks, the Original
	// and Processed templates are always available. For change sets, the Original
	// template is always available. After AWS CloudFormation finishes creating
	// the change set, the Processed template becomes available.
	StagesAvailable []TemplateStage `type:"list"`

	// Structure containing the template body. (For more information, go to Template
	// Anatomy (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// AWS CloudFormation returns the same template that was used when the stack
	// was created.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns the template body for a specified stack. You can get the template
// for running or deleted stacks.
//
// For deleted stacks, GetTemplate returns the template for up to 90 days after
// the stack has been deleted.
//
// If the template does not exist, a ValidationError is returned.
//
//    // Example sending a request using GetTemplateRequest.
//    req := client.GetTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate
func (c *Client) GetTemplateRequest(input *GetTemplateInput) GetTemplateRequest {
	op := &aws.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	req := c.newRequest(op, input, &GetTemplateOutput{})
	return GetTemplateRequest{Request: req, Input: input, Copy: c.GetTemplateRequest}
}

// GetTemplateRequest is the request type for the
// GetTemplate API operation.
type GetTemplateRequest struct {
	*aws.Request
	Input *GetTemplateInput
	Copy  func(*GetTemplateInput) GetTemplateRequest
}

// Send marshals and sends the GetTemplate API request.
func (r GetTemplateRequest) Send(ctx context.Context) (*GetTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTemplateResponse{
		GetTemplateOutput: r.Request.Data.(*GetTemplateOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetTemplateResponse is the response type for the
// GetTemplate API operation.
type GetTemplateResponse struct {
	*GetTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTemplate request.
func (r *GetTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
