// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateObjectAttributesRequest
type UpdateObjectAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes update structure.
	//
	// AttributeUpdates is a required field
	AttributeUpdates []ObjectAttributeUpdate `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// the object resides. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The reference that identifies the object.
	//
	// ObjectReference is a required field
	ObjectReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateObjectAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateObjectAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateObjectAttributesInput"}

	if s.AttributeUpdates == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeUpdates"))
	}

	if s.DirectoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryArn"))
	}

	if s.ObjectReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectReference"))
	}
	if s.AttributeUpdates != nil {
		for i, v := range s.AttributeUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateObjectAttributesInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.AttributeUpdates) > 0 {
		v := s.AttributeUpdates

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AttributeUpdates", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ObjectReference != nil {
		v := s.ObjectReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ObjectReference", v, metadata)
	}
	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateObjectAttributesResponse
type UpdateObjectAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier of the updated object.
	ObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s UpdateObjectAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateObjectAttributesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ObjectIdentifier != nil {
		v := *s.ObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateObjectAttributes = "UpdateObjectAttributes"

// UpdateObjectAttributesRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Updates a given object's attributes.
//
//    // Example sending a request using UpdateObjectAttributesRequest.
//    req := client.UpdateObjectAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/UpdateObjectAttributes
func (c *Client) UpdateObjectAttributesRequest(input *UpdateObjectAttributesInput) UpdateObjectAttributesRequest {
	op := &aws.Operation{
		Name:       opUpdateObjectAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/update",
	}

	if input == nil {
		input = &UpdateObjectAttributesInput{}
	}

	req := c.newRequest(op, input, &UpdateObjectAttributesOutput{})
	return UpdateObjectAttributesRequest{Request: req, Input: input, Copy: c.UpdateObjectAttributesRequest}
}

// UpdateObjectAttributesRequest is the request type for the
// UpdateObjectAttributes API operation.
type UpdateObjectAttributesRequest struct {
	*aws.Request
	Input *UpdateObjectAttributesInput
	Copy  func(*UpdateObjectAttributesInput) UpdateObjectAttributesRequest
}

// Send marshals and sends the UpdateObjectAttributes API request.
func (r UpdateObjectAttributesRequest) Send(ctx context.Context) (*UpdateObjectAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateObjectAttributesResponse{
		UpdateObjectAttributesOutput: r.Request.Data.(*UpdateObjectAttributesOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateObjectAttributesResponse is the response type for the
// UpdateObjectAttributes API operation.
type UpdateObjectAttributesResponse struct {
	*UpdateObjectAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateObjectAttributes request.
func (r *UpdateObjectAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
