// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloud9

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about an AWS Cloud9 development environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/Environment
type Environment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string `locationName:"arn" type:"string"`

	// The description for the environment.
	Description *string `locationName:"description" type:"string"`

	// The ID of the environment.
	Id *string `locationName:"id" type:"string"`

	// The state of the environment in its creation or deletion lifecycle.
	Lifecycle *EnvironmentLifecycle `locationName:"lifecycle" type:"structure"`

	// The name of the environment.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the environment owner.
	OwnerArn *string `locationName:"ownerArn" type:"string"`

	// The type of environment. Valid values include the following:
	//
	//    * ec2: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects
	//    to the environment.
	//
	//    * ssh: Your own server connects to the environment.
	Type EnvironmentType `locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// Information about the current creation or deletion lifecycle state of an
// AWS Cloud9 development environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/EnvironmentLifecycle
type EnvironmentLifecycle struct {
	_ struct{} `type:"structure"`

	// If the environment failed to delete, the Amazon Resource Name (ARN) of the
	// related AWS resource.
	FailureResource *string `locationName:"failureResource" type:"string"`

	// Any informational message about the lifecycle state of the environment.
	Reason *string `locationName:"reason" type:"string"`

	// The current creation or deletion lifecycle state of the environment.
	//
	//    * CREATED: The environment was successfully created.
	//
	//    * DELETE_FAILED: The environment failed to delete.
	//
	//    * DELETING: The environment is in the process of being deleted.
	Status EnvironmentLifecycleStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s EnvironmentLifecycle) String() string {
	return awsutil.Prettify(s)
}

// Information about an environment member for an AWS Cloud9 development environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/EnvironmentMember
type EnvironmentMember struct {
	_ struct{} `type:"structure"`

	// The ID of the environment for the environment member.
	EnvironmentId *string `locationName:"environmentId" type:"string"`

	// The time, expressed in epoch time format, when the environment member last
	// opened the environment.
	LastAccess *time.Time `locationName:"lastAccess" type:"timestamp" timestampFormat:"unix"`

	// The type of environment member permissions associated with this environment
	// member. Available values include:
	//
	//    * owner: Owns the environment.
	//
	//    * read-only: Has read-only access to the environment.
	//
	//    * read-write: Has read-write access to the environment.
	Permissions Permissions `locationName:"permissions" type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the environment member.
	UserArn *string `locationName:"userArn" type:"string"`

	// The user ID in AWS Identity and Access Management (AWS IAM) of the environment
	// member.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s EnvironmentMember) String() string {
	return awsutil.Prettify(s)
}
